# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1478-1 (mysql-dfsg-5.0)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60271);
 script_cve_id("CVE-2008-0226", "CVE-2008-0227");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1478-1 (mysql-dfsg-5.0)";
 script_name(name);

 desc = "The remote host is missing an update to mysql-dfsg-5.0
announced via advisory DSA 1478-1.

Luigi Auriemma discovered two buffer overflows in YaSSL, an SSL
implementation included in the MySQL database package, which could lead
to denial of service and possibly the execution of arbitrary code.

For the unstable distribution (sid), these problems have been fixed in
version 5.0.51-3.

For the stable distribution (etch), these problems have been fixed in
version 5.0.32-7etch5.

The old stable distribution (sarge) doesn't contain mysql-dfsg-5.0.

We recommend that you upgrade your mysql-dfsg-5.0 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201478-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1478-1 (mysql-dfsg-5.0)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.32-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.32-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.32-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.32-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.32-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client-5.0", ver:"5.0.32-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-5.0", ver:"5.0.32-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-4.1", ver:"5.0.32-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
