###############################################################################
# OpenVAS Vulnerability Test
# $Id: cms_made_simple_38234.nasl 7198 2010-04-01 09:23:35Z chandra $
#
# CMS Made Simple Local File Include and Cross Site Scripting Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100498);
 script_bugtraq_id(38234);
 script_version ("1.0-$Revision: 7198 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("CMS Made Simple Local File Include and Cross Site Scripting Vulnerabilities");

desc = "Overview:
CMS Made Simple is prone to a local file-include vulnerability and a
cross-site scripting vulnerability because it fails to properly
sanitize user-supplied input.

An attacker can exploit the local file-include vulnerability using
directory-traversal strings to view and execute local files within
the context of the webserver process. Information harvested may aid
in further attacks.

The attacker may leverage the cross-site scripting issue to execute
arbitrary script code in the browser of an unsuspecting user in the
context of the affected site. This may let the attacker steal cookie-
based authentication credentials and launch other attacks.

CMS Made Simple 1.6.6 is affected; other versions may also be
vulnerable.

References:
http://www.securityfocus.com/bid/38234
http://www.cmsmadesimple.org/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if CMS Made Simple version is 1.6.6");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("cms_made_simple_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/cms_made_simple")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "1.6.6")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
