//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Model
 *
 *  Copyright 2005-2024 Airbus-EDF-IMACS-ONERA-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTMODEL_HXX
#define OPENTURNS_OTMODEL_HXX

#include "openturns/ArchimedeanCopula.hxx"
#include "openturns/CompositeRandomVector.hxx"
#include "openturns/ConditionalRandomVector.hxx"
#include "openturns/ConstantRandomVector.hxx"
#include "openturns/Distribution.hxx"
#include "openturns/DistributionFactory.hxx"
#include "openturns/DistributionImplementation.hxx"
#include "openturns/DistributionFactoryImplementation.hxx"
#include "openturns/DistributionParametersImplementation.hxx"
#include "openturns/DistributionParameters.hxx"
#include "openturns/EllipticalDistribution.hxx"
#include "openturns/DomainEvent.hxx"
#include "openturns/ThresholdEvent.hxx"
#include "openturns/ProcessEvent.hxx"
#include "openturns/IntersectionEvent.hxx"
#include "openturns/UnionEvent.hxx"
#include "openturns/FunctionalChaosRandomVector.hxx"
#include "openturns/KrigingRandomVector.hxx"
#include "openturns/ProcessImplementation.hxx"
#include "openturns/Process.hxx"
#include "openturns/RandomVector.hxx"
#include "openturns/RandomVectorImplementation.hxx"
#include "openturns/SklarCopula.hxx"
#include "openturns/StandardEvent.hxx"
#include "openturns/UsualRandomVector.hxx"

#endif /* OPENTURNS_OTMODEL_HXX */
