/* 
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javafx.scene.media;

/**
Builder class for javafx.scene.media.MediaPlayer
@see javafx.scene.media.MediaPlayer
@deprecated This class is deprecated and will be removed in the next version
* @since JavaFX 2.0
*/
@javax.annotation.Generated("Generated by javafx.builder.processor.BuilderProcessor")
@Deprecated
public final class MediaPlayerBuilder implements javafx.util.Builder<javafx.scene.media.MediaPlayer> {
    protected MediaPlayerBuilder() {
    }
    
    /** Creates a new instance of MediaPlayerBuilder. */
    @SuppressWarnings({"deprecation", "rawtypes", "unchecked"})
    public static javafx.scene.media.MediaPlayerBuilder create() {
        return new javafx.scene.media.MediaPlayerBuilder();
    }
    
    private int __set;
    private void __set(int i) {
        __set |= 1 << i;
    }
    public void applyTo(javafx.scene.media.MediaPlayer x) {
        int set = __set;
        while (set != 0) {
            int i = Integer.numberOfTrailingZeros(set);
            set &= ~(1 << i);
            switch (i) {
                case 0: x.setAudioSpectrumInterval(this.audioSpectrumInterval); break;
                case 1: x.setAudioSpectrumListener(this.audioSpectrumListener); break;
                case 2: x.setAudioSpectrumNumBands(this.audioSpectrumNumBands); break;
                case 3: x.setAudioSpectrumThreshold(this.audioSpectrumThreshold); break;
                case 4: x.setAutoPlay(this.autoPlay); break;
                case 5: x.setBalance(this.balance); break;
                case 6: x.setCycleCount(this.cycleCount); break;
                case 7: x.setMute(this.mute); break;
                case 8: x.setOnEndOfMedia(this.onEndOfMedia); break;
                case 9: x.setOnError(this.onError); break;
                case 10: x.setOnHalted(this.onHalted); break;
                case 11: x.setOnMarker(this.onMarker); break;
                case 12: x.setOnPaused(this.onPaused); break;
                case 13: x.setOnPlaying(this.onPlaying); break;
                case 14: x.setOnReady(this.onReady); break;
                case 15: x.setOnRepeat(this.onRepeat); break;
                case 16: x.setOnStalled(this.onStalled); break;
                case 17: x.setOnStopped(this.onStopped); break;
                case 18: x.setRate(this.rate); break;
                case 19: x.setStartTime(this.startTime); break;
                case 20: x.setStopTime(this.stopTime); break;
                case 21: x.setVolume(this.volume); break;
            }
        }
    }
    
    private double audioSpectrumInterval;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getAudioSpectrumInterval() audioSpectrumInterval} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder audioSpectrumInterval(double x) {
        this.audioSpectrumInterval = x;
        __set(0);
        return this;
    }
    
    private javafx.scene.media.AudioSpectrumListener audioSpectrumListener;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getAudioSpectrumListener() audioSpectrumListener} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder audioSpectrumListener(javafx.scene.media.AudioSpectrumListener x) {
        this.audioSpectrumListener = x;
        __set(1);
        return this;
    }
    
    private int audioSpectrumNumBands;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getAudioSpectrumNumBands() audioSpectrumNumBands} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder audioSpectrumNumBands(int x) {
        this.audioSpectrumNumBands = x;
        __set(2);
        return this;
    }
    
    private int audioSpectrumThreshold;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getAudioSpectrumThreshold() audioSpectrumThreshold} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder audioSpectrumThreshold(int x) {
        this.audioSpectrumThreshold = x;
        __set(3);
        return this;
    }
    
    private boolean autoPlay;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#isAutoPlay() autoPlay} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder autoPlay(boolean x) {
        this.autoPlay = x;
        __set(4);
        return this;
    }
    
    private double balance;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getBalance() balance} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder balance(double x) {
        this.balance = x;
        __set(5);
        return this;
    }
    
    private int cycleCount;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getCycleCount() cycleCount} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder cycleCount(int x) {
        this.cycleCount = x;
        __set(6);
        return this;
    }
    
    private javafx.scene.media.Media media;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getMedia() media} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder media(javafx.scene.media.Media x) {
        this.media = x;
        return this;
    }
    
    private boolean mute;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#isMute() mute} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder mute(boolean x) {
        this.mute = x;
        __set(7);
        return this;
    }
    
    private java.lang.Runnable onEndOfMedia;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnEndOfMedia() onEndOfMedia} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onEndOfMedia(java.lang.Runnable x) {
        this.onEndOfMedia = x;
        __set(8);
        return this;
    }
    
    private java.lang.Runnable onError;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnError() onError} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onError(java.lang.Runnable x) {
        this.onError = x;
        __set(9);
        return this;
    }
    
    private java.lang.Runnable onHalted;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnHalted() onHalted} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onHalted(java.lang.Runnable x) {
        this.onHalted = x;
        __set(10);
        return this;
    }
    
    private javafx.event.EventHandler<javafx.scene.media.MediaMarkerEvent> onMarker;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnMarker() onMarker} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onMarker(javafx.event.EventHandler<javafx.scene.media.MediaMarkerEvent> x) {
        this.onMarker = x;
        __set(11);
        return this;
    }
    
    private java.lang.Runnable onPaused;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnPaused() onPaused} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onPaused(java.lang.Runnable x) {
        this.onPaused = x;
        __set(12);
        return this;
    }
    
    private java.lang.Runnable onPlaying;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnPlaying() onPlaying} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onPlaying(java.lang.Runnable x) {
        this.onPlaying = x;
        __set(13);
        return this;
    }
    
    private java.lang.Runnable onReady;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnReady() onReady} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onReady(java.lang.Runnable x) {
        this.onReady = x;
        __set(14);
        return this;
    }
    
    private java.lang.Runnable onRepeat;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnRepeat() onRepeat} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onRepeat(java.lang.Runnable x) {
        this.onRepeat = x;
        __set(15);
        return this;
    }
    
    private java.lang.Runnable onStalled;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnStalled() onStalled} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onStalled(java.lang.Runnable x) {
        this.onStalled = x;
        __set(16);
        return this;
    }
    
    private java.lang.Runnable onStopped;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getOnStopped() onStopped} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder onStopped(java.lang.Runnable x) {
        this.onStopped = x;
        __set(17);
        return this;
    }
    
    private double rate;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getRate() rate} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder rate(double x) {
        this.rate = x;
        __set(18);
        return this;
    }
    
    private javafx.util.Duration startTime;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getStartTime() startTime} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder startTime(javafx.util.Duration x) {
        this.startTime = x;
        __set(19);
        return this;
    }
    
    private javafx.util.Duration stopTime;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getStopTime() stopTime} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder stopTime(javafx.util.Duration x) {
        this.stopTime = x;
        __set(20);
        return this;
    }
    
    private double volume;
    /**
    Set the value of the {@link javafx.scene.media.MediaPlayer#getVolume() volume} property for the instance constructed by this builder.
    */
    public javafx.scene.media.MediaPlayerBuilder volume(double x) {
        this.volume = x;
        __set(21);
        return this;
    }
    
    /**
    Make an instance of {@link javafx.scene.media.MediaPlayer} based on the properties set on this builder.
    */
    public javafx.scene.media.MediaPlayer build() {
        javafx.scene.media.MediaPlayer x = new javafx.scene.media.MediaPlayer(this.media);
        applyTo(x);
        return x;
    }
}
