#!/bin/sh

postProcessInDirectory()
{
    cd "$1"

    local unifdefOptions sedExpression

    if [[ ${USE_INTERNAL_SDK} == "YES" ]]; then
        USE_APPLE_INTERNAL_SDK=1
    else
        USE_APPLE_INTERNAL_SDK=0
    fi

    if [[ ${PLATFORM_NAME} == macosx ]]; then
        unifdefOptions="-DTARGET_OS_EMBEDDED=0 -DTARGET_OS_IPHONE=0 -DTARGET_IPHONE_SIMULATOR=0";
    elif [[ ${PLATFORM_NAME} == *simulator* ]]; then
        unifdefOptions="-DTARGET_OS_EMBEDDED=0 -DTARGET_OS_IPHONE=1 -DTARGET_IPHONE_SIMULATOR=1 -DUSE_APPLE_INTERNAL_SDK=${USE_APPLE_INTERNAL_SDK}";
    else
        unifdefOptions="-DTARGET_OS_EMBEDDED=1 -DTARGET_OS_IPHONE=1 -DTARGET_IPHONE_SIMULATOR=0 -DUSE_APPLE_INTERNAL_SDK=${USE_APPLE_INTERNAL_SDK}";
    fi

    # FIXME: We should consider making this logic general purpose so as to support keeping or removing
    # code guarded by an arbitrary feature define. For now it's sufficient to process touch- and gesture-
    # guarded code.
    for featureDefine in "ENABLE_TOUCH_EVENTS" "ENABLE_IOS_GESTURE_EVENTS"
    do
        # We assume a disabled feature is either undefined or has the empty string as its value.
        eval "isFeatureEnabled=\$$featureDefine"
        if [[ -z $isFeatureEnabled ]]; then
            unifdefOptions="$unifdefOptions -D$featureDefine=0"
        else
            unifdefOptions="$unifdefOptions -D$featureDefine=1"
        fi
    done

    if [[ ${PLATFORM_NAME} == macosx ]]; then
        sedExpression='s/WEBKIT_((CLASS_|ENUM_)?AVAILABLE|DEPRECATED)/NS_\1/g';
    else
        sedExpression='s/ *WEBKIT_((CLASS_|ENUM_)?AVAILABLE|DEPRECATED)_MAC\([^)]+\)//g';
    fi

    for header in $(find . -name '*.h' -type f); do
        unifdef -B ${unifdefOptions} -o ${header}.unifdef ${header}
        case $? in
        0)
            rm ${header}.unifdef
            ;;
        1)
            mv ${header}{.unifdef,}
            ;;
        *)
            exit 1
            ;;
        esac

        if [[ ${header} == "./WebKitAvailability.h" ]]; then
            continue
        fi

        sed -E -e "${sedExpression}" < ${header} > ${header}.sed
        if cmp -s ${header} ${header}.sed; then
            rm ${header}.sed
        else
            mv ${header}.sed ${header}
        fi
    done
}

postProcessInDirectory "${TARGET_BUILD_DIR}/${PUBLIC_HEADERS_FOLDER_PATH}"
postProcessInDirectory "${TARGET_BUILD_DIR}/${PRIVATE_HEADERS_FOLDER_PATH}"
