/*
 * Copyright (C) 2012-2018 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#include "ArithProfile.h"
#include "ArrayProfile.h"
#include "BytecodeIndices.h"
#include "BytecodeStructs.h"
#include "CodeBlock.h"
#include "CommonSlowPaths.h"
#include "DirectArguments.h"
#include "DirectEvalExecutable.h"
#include "EvalExecutable.h"
#include "Exception.h"
#include "GetByIdMetadata.h"
#include "Heap.h"
#include "IndirectEvalExecutable.h"
#include "Interpreter.h"
#include "JSArray.h"
#include "JSArrayBufferView.h"
#include "JSCPtrTag.h"
#include "JSCast.h"
#include "JSFunction.h"
#include "JSGlobalObject.h"
#include "JSInternalFieldObjectImpl.h"
#include "JSLexicalEnvironment.h"
#include "JSModuleRecord.h"
#include "JSObject.h"
#include "JSString.h"
#include "JSTypeInfo.h"
#include "JumpTable.h"
#include "LLIntData.h"
#include "LLIntOfflineAsmConfig.h"
#include "MarkedSpace.h"
#include "MaxFrameExtentForSlowPathCall.h"
#include "NativeExecutable.h"
#include "PutByIdFlags.h"
#include "ProtoCallFrame.h"
#include "ShadowChicken.h"
#include "Structure.h"
#include "StructureChain.h"
#include "TypeProfiler.h"
#include "TypeProfilerLog.h"
#include "VM.h"
#include "ValueProfile.h"
#include "WasmCallingConvention.h"
#include "WasmFunctionCodeBlock.h"
#include "WasmInstance.h"
#include "Watchdog.h"
#include "WebAssemblyFunction.h"
#include <stdio.h>
#include <wtf/FastTLS.h>
#include <wtf/text/StringImpl.h>

namespace JSC {

#define OFFLINE_ASM_OFFSETOF(clazz, field) (static_cast<unsigned>(OBJECT_OFFSETOF(clazz, field)))

class LLIntOffsetsExtractor {
    // These types are useful since we can't use '<...>' syntax in LLInt offsets extraction. e.g. Vector<int>::m_data
    using Vector = WTF::Vector<int>;
    using JSInternalFieldObjectImpl = JSC::JSInternalFieldObjectImpl<>;
    using RefCountedArray = WTF::RefCountedArray<int>;

public:
    static const int64_t* dummy();
};

const int64_t* LLIntOffsetsExtractor::dummy()
{
// This is a file generated by offlineasm/generate_offset_extractor.rb, and contains code
// to create a table of offsets, sizes, and a header identifying what combination of
// Platform.h macros we have set. We include it inside of a method on LLIntOffsetsExtractor
// because the fields whose offsets we're extracting are mostly private. So we make their
// classes friends with LLIntOffsetsExtractor, and include the header here, to get the C++
// compiler to kindly step aside and yield to our best intentions.
#include "LLIntDesiredOffsets.h"
    return offsetExtractorTable;
}

} // namespace JSC

int main(int, char**)
{
    // Out of an abundance of caution, make sure that LLIntOffsetsExtractor::dummy() is live,
    // and the extractorTable is live, too.
    printf("%p\n", JSC::LLIntOffsetsExtractor::dummy());
    return 0;
}


