/*
 * Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


/*
 * @test
 *
 * @summary converted from VM Testbase nsk/jdi/ReferenceType/sourceDebugExtension/srcdebugx002.
 * VM Testbase keywords: [jpda, jdi]
 * VM Testbase readme:
 * DESCRIPTION
 *     This test checks that the JDI method ReferenceType.sourceDebugExtension()
 *     properly returns the SourceDebugExtension Class File attribute.
 *     String obtained from the sourceDebugExtension() is compared with
 *     the expected attribute string.
 * COMMENTS
 *     The file srcdebugx002x.jcod has been generated by the JCK's SQE tool Jdec
 *     for the class file compiled by Javac from a source file srcdebugx002x.java
 *     which is located at the directory srcdebugx.jdec. Please note that only
 *     the Jcoder tool implemented the RFE 4460411, must be used.
 *     The test was updated due to the bug 4422724.
 *     To fix the bug 4493107, a corresponding check is added.
 *
 * @library /vmTestbase
 *          /test/lib
 * @build nsk.jdi.ReferenceType.sourceDebugExtension.srcdebugx002
 *        nsk.jdi.ReferenceType.sourceDebugExtension.srcdebugx002t
 * @compile srcdebugx002x.jcod
 *
 * @run main/othervm
 *      nsk.jdi.ReferenceType.sourceDebugExtension.srcdebugx002
 *      -verbose
 *      -arch=${os.family}-${os.simpleArch}
 *      -waittime=5
 *      -debugee.vmkind=java
 *      -transport.address=dynamic
 *      -debugee.vmkeys="${test.vm.opts} ${test.java.opts}"
 */

