// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GccAna_Circ2dTanCen_HeaderFile
#define _GccAna_Circ2dTanCen_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColgp_Array1OfCirc2d_HeaderFile
#include <TColgp_Array1OfCirc2d.hxx>
#endif
#ifndef _GccEnt_Array1OfPosition_HeaderFile
#include <GccEnt_Array1OfPosition.hxx>
#endif
#ifndef _TColStd_Array1OfInteger_HeaderFile
#include <TColStd_Array1OfInteger.hxx>
#endif
#ifndef _TColgp_Array1OfPnt2d_HeaderFile
#include <TColgp_Array1OfPnt2d.hxx>
#endif
#ifndef _TColStd_Array1OfReal_HeaderFile
#include <TColStd_Array1OfReal.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GccEnt_Position_HeaderFile
#include <GccEnt_Position.hxx>
#endif
class Standard_NegativeValue;
class Standard_OutOfRange;
class StdFail_NotDone;
class GccEnt_BadQualifier;
class GccEnt_QualifiedCirc;
class gp_Pnt2d;
class gp_Lin2d;
class gp_Circ2d;


//! This class implements the algorithms used to <br>
//!          create 2d circles tangent to an entity and <br>
//!          centered on a point. <br>
//!          The arguments of all construction methods are : <br>
//!             - The qualified element for the tangency constrains <br>
//!             (QualifiedCirc, Line, Point). <br>
//!             - The center point Pcenter. <br>
//!             - A real Tolerance. <br>
//!          Tolerance is only used in the limits cases. <br>
//!          For example : <br>
//!          We want to create a circle tangent to an EnclosedCirc C1 <br>
//!          with a tolerance Tolerance. <br>
//!          If we did not used Tolerance it is impossible to <br>
//!          find a solution in the the following case : Pcenter is <br>
//!          outside C1. <br>
//!          With Tolerance we will give a solution if the distance <br>
//!          between C1 and Pcenter is lower than or equal Tolerance. <br>
class GccAna_Circ2dTanCen  {
public:

  DEFINE_STANDARD_ALLOC

  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to a circle and <br>
//!          centered on a point. <br>
  Standard_EXPORT   GccAna_Circ2dTanCen(const GccEnt_QualifiedCirc& Qualified1,const gp_Pnt2d& Pcenter,const Standard_Real Tolerance);
  //! This method implements the algorithms used to <br>
//!          create 2d circles tangent to a line and <br>
//!          centered on a point. <br>
  Standard_EXPORT   GccAna_Circ2dTanCen(const gp_Lin2d& Linetan,const gp_Pnt2d& Pcenter);
  //! This method implements the algorithms used to <br>
//!          create 2d circles passing thrue a point and <br>
//!          centered on a point. <br>
//! Tolerance is a tolerance criterion used by the algorithm <br>
//! to find a solution when, mathematically, the problem <br>
//! posed does not have a solution, but where there is <br>
//! numeric uncertainty attached to the arguments. <br>
//! In these algorithms Tolerance is only used in very <br>
//! specific cases where the center of the solution is very <br>
//! close to the circle to which it is tangential, and where the <br>
//! solution is therefore a very small circle. <br>
//! Exceptions <br>
//! GccEnt_BadQualifier if a qualifier is inconsistent with <br>
//! the argument it qualifies (for example, enclosing for a line). <br>
  Standard_EXPORT   GccAna_Circ2dTanCen(const gp_Pnt2d& Point1,const gp_Pnt2d& Pcenter);
  //! This method returns True if the construction <br>
//!          algorithm succeeded. <br>
//! Note: IsDone protects against a failure arising from a <br>
//! more internal intersection algorithm, which has reached <br>
//! its numeric limits. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! Returns the number of circles, representing solutions <br>
//! computed by this algorithm and raises NotDone <br>
//!          exception if the algorithm didn't succeed. <br>
  Standard_EXPORT     Standard_Integer NbSolutions() const;
  //! Returns the circle, representing the solution number Index and raises OutOfRange <br>
//!          exception if Index is greater than the number of solutions. <br>
//!          Be carefull: the Index is only a way to get all the <br>
//!          solutions, but is not associated to theses outside the <br>
//!          context of the algorithm-object. <br>
//! Raises NotDone if the construction algorithm didn't succeed. <br>
//!          It raises OutOfRange if Index is greater than the <br>
//!          number of solutions or less than zer <br>
  Standard_EXPORT     gp_Circ2d ThisSolution(const Standard_Integer Index) const;
  //! Returns the qualifier Qualif1 of the tangency argument <br>
//! for the solution of index Index computed by this algorithm. <br>
//! The returned qualifier is: <br>
//! -   that specified at the start of construction when the <br>
//!   solutions are defined as enclosed, enclosing or <br>
//! It returns the real qualifiers (the qualifiers given to the <br>
//! constructor method in case of enclosed, enclosing and outside <br>
//! and the qualifiers computedin case of unqualified). <br>
  Standard_EXPORT     void WhichQualifier(const Standard_Integer Index,GccEnt_Position& Qualif1) const;
  //! Returns informations about the tangency point between the <br>
//!          result number Index and the first argument. <br>
//!          ParSol is the intrinsic parameter of the point PntSol <br>
//!          on the solution curv. <br>
//!          ParArg is the intrinsic parameter of the point PntArg <br>
//!          on the argument curv. <br>//! It raises NotDone if the construction algorithm <br>
//!          didn't succeed. <br>
//!          It raises OutOfRange if Index is greater than the <br>
//!          number of solutions or less than zero. <br>
  Standard_EXPORT     void Tangency1(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns True if the solution number Index is equal to <br>
//!          the first argument. <br>//! It raises NotDone if the construction algorithm <br>
//!          didn't succeed. <br>
//!          It raises OutOfRange if Index is greater than the <br>
//!          number of solutions or less than zero. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame1(const Standard_Integer Index) const;





protected:





private:



Standard_Boolean WellDone;
Standard_Integer NbrSol;
TColgp_Array1OfCirc2d cirsol;
GccEnt_Array1OfPosition qualifier1;
TColStd_Array1OfInteger TheSame1;
TColgp_Array1OfPnt2d pnttg1sol;
TColStd_Array1OfReal par1sol;
TColStd_Array1OfReal pararg1;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
