// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Extrema_GenExtCS_HeaderFile
#define _Extrema_GenExtCS_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColgp_HArray1OfPnt_HeaderFile
#include <Handle_TColgp_HArray1OfPnt.hxx>
#endif
#ifndef _Handle_TColgp_HArray2OfPnt_HeaderFile
#include <Handle_TColgp_HArray2OfPnt.hxx>
#endif
#ifndef _Extrema_FuncExtCS_HeaderFile
#include <Extrema_FuncExtCS.hxx>
#endif
#ifndef _Adaptor3d_SurfacePtr_HeaderFile
#include <Adaptor3d_SurfacePtr.hxx>
#endif
#ifndef _Adaptor3d_CurvePtr_HeaderFile
#include <Adaptor3d_CurvePtr.hxx>
#endif
class TColgp_HArray1OfPnt;
class TColgp_HArray2OfPnt;
class StdFail_NotDone;
class Standard_OutOfRange;
class Standard_TypeMismatch;
class Adaptor3d_Curve;
class Adaptor3d_Surface;
class Extrema_POnCurv;
class Extrema_POnSurf;


//! It calculates all the extremum distances <br>
//!          between acurve and a surface. <br>
//!          These distances can be minimum or maximum. <br>
class Extrema_GenExtCS  {
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT   Extrema_GenExtCS();
  //! It calculates all the distances. <br>
//!          The function F(u,v)=distance(S1(u1,v1),S2(u2,v2)) has an <br>
//!          extremum when gradient(F)=0. The algorithm searchs <br>
//!          all the zeros inside the definition ranges of the <br>
//!          surfaces. <br>
//!          NbU and NbV are used to locate the close points on the <br>
//!          surface and NbT on the curve to find the zeros. <br>
  Standard_EXPORT   Extrema_GenExtCS(const Adaptor3d_Curve& C,const Adaptor3d_Surface& S,const Standard_Integer NbT,const Standard_Integer NbU,const Standard_Integer NbV,const Standard_Real Tol1,const Standard_Real Tol2);
  //! It calculates all the distances. <br>
//!          The function F(u,v)=distance(P,S(u,v)) has an <br>
//!          extremum when gradient(F)=0. The algorithm searchs <br>
//!          all the zeros inside the definition ranges of the <br>
//!          surface. <br>
//!          NbT,NbU and NbV are used to locate the close points <br>
//!          to find the zeros. <br>
  Standard_EXPORT   Extrema_GenExtCS(const Adaptor3d_Curve& C,const Adaptor3d_Surface& S,const Standard_Integer NbT,const Standard_Integer NbU,const Standard_Integer NbV,const Standard_Real tmin,const Standard_Real tsup,const Standard_Real Umin,const Standard_Real Usup,const Standard_Real Vmin,const Standard_Real Vsup,const Standard_Real Tol1,const Standard_Real Tol2);
  
  Standard_EXPORT     void Initialize(const Adaptor3d_Surface& S,const Standard_Integer NbU,const Standard_Integer NbV,const Standard_Real Tol2) ;
  
  Standard_EXPORT     void Initialize(const Adaptor3d_Surface& S,const Standard_Integer NbU,const Standard_Integer NbV,const Standard_Real Umin,const Standard_Real Usup,const Standard_Real Vmin,const Standard_Real Vsup,const Standard_Real Tol2) ;
  //! the algorithm is done with S <br>
//!          An exception is raised if the fields have not <br>
//!          been initialized. <br>
  Standard_EXPORT     void Perform(const Adaptor3d_Curve& C,const Standard_Integer NbT,const Standard_Real Tol1) ;
  //! the algorithm is done with C <br>
//!          An exception is raised if the fields have not <br>
//!          been initialized. <br>
  Standard_EXPORT     void Perform(const Adaptor3d_Curve& C,const Standard_Integer NbT,const Standard_Real tmin,const Standard_Real tsup,const Standard_Real Tol1) ;
  //! Returns True if the distances are found. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! Returns the number of extremum distances. <br>
  Standard_EXPORT     Standard_Integer NbExt() const;
  //! Returns the value of the Nth resulting square distance. <br>
  Standard_EXPORT     Standard_Real SquareDistance(const Standard_Integer N) const;
  //! Returns the point of the Nth resulting distance. <br>
  Standard_EXPORT    const Extrema_POnCurv& PointOnCurve(const Standard_Integer N) const;
  //! Returns the point of the Nth resulting distance. <br>
  Standard_EXPORT    const Extrema_POnSurf& PointOnSurface(const Standard_Integer N) const;





protected:





private:

  
  Standard_EXPORT     Adaptor3d_CurvePtr BidonCurve() const;
  
  Standard_EXPORT     Adaptor3d_SurfacePtr BidonSurface() const;


Standard_Boolean myDone;
Standard_Boolean myInit;
Standard_Real mytmin;
Standard_Real mytsup;
Standard_Real myumin;
Standard_Real myusup;
Standard_Real myvmin;
Standard_Real myvsup;
Standard_Integer mytsample;
Standard_Integer myusample;
Standard_Integer myvsample;
Handle_TColgp_HArray1OfPnt mypoints1;
Handle_TColgp_HArray2OfPnt mypoints2;
Standard_Real mytol1;
Standard_Real mytol2;
Extrema_FuncExtCS myF;
Adaptor3d_SurfacePtr myS;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
