#!/bin/bash
set -e
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
cd $SCRIPT_DIR > /dev/null

export SAUCE_USERNAME=sinonjs

if [ -z $SAUCE_ACCESS_KEY ]; then
    echo 'SAUCE_ACCESS_KEY has not been exported and made available for test `test-cloud` script!'
    exit 1
fi

npm run lint
npm test # lints and tests

echo "We have issues running the test-cloud script successfully due to networking issues"
echo DISABLED: npm run test-cloud # should not take more than approx 25 seconds
