---
id: fast-foundation.search
title: Search class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Search](./fast-foundation.search.md)

## Search class

A Search Custom HTML Element. Based largely on the [&lt;input type="search" /&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/search)<!-- -->.


start - Content which can be provided before the search input


end - Content which can be provided after the search clear button


- The default slot for the label


close-button - The clear button


close-glyph - The clear glyph


label - The label


root - The element wrapping the control, including start and end slots


control - The element representing the input


clear-button - The button to clear the input

<b>Signature:</b>

```typescript
export declare class Search extends FormAssociatedSearch 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [autofocus](./fast-foundation.search.autofocus.md) |  | boolean | Indicates that this element should get focus after the page finishes loading. See [autofocus HTML attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefautofocus) for more information. |
|  [list](./fast-foundation.search.list.md) |  | string | Allows associating a [datalist](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/datalist) to the element by [https://developer.mozilla.org/en-US/docs/Web/API/Element/id](https://developer.mozilla.org/en-US/docs/Web/API/Element/id)<!-- -->. |
|  [maxlength](./fast-foundation.search.maxlength.md) |  | number | The maximum number of characters a user can enter. |
|  [minlength](./fast-foundation.search.minlength.md) |  | number | The minimum number of characters a user can enter. |
|  [pattern](./fast-foundation.search.pattern.md) |  | string | A regular expression that the value must match to pass validation. |
|  [placeholder](./fast-foundation.search.placeholder.md) |  | string | Sets the placeholder value of the element, generally used to provide a hint to the user. |
|  [readOnly](./fast-foundation.search.readonly.md) |  | boolean | When true, the control will be immutable by user interaction. See [readonly HTML attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/readonly) for more information. |
|  [size](./fast-foundation.search.size.md) |  | number | Sets the width of the element to a specified number of characters. |
|  [spellcheck](./fast-foundation.search.spellcheck.md) |  | boolean | Controls whether or not to enable spell checking for the input field, or if the default spell checking configuration should be used. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [handleClearInput()](./fast-foundation.search.handleclearinput.md) |  | Handles the control's clear value event |
