var tape = require("tape"),
    time = require("../"),
    date = require("./date");

tape("timeYear.floor(date) returns years", function(test) {
  test.deepEqual(time.timeYear.floor(date.local(2010, 11, 31, 23, 59, 59)), date.local(2010, 00, 01));
  test.deepEqual(time.timeYear.floor(date.local(2011, 00, 01, 00, 00, 00)), date.local(2011, 00, 01));
  test.deepEqual(time.timeYear.floor(date.local(2011, 00, 01, 00, 00, 01)), date.local(2011, 00, 01));
  test.end();
});

tape("timeYear.floor(date) does not modify the specified date", function(test) {
  var d = date.local(2010, 11, 31, 23, 59, 59);
  test.deepEqual(time.timeYear.floor(d), date.local(2010, 00, 01));
  test.deepEqual(d, date.local(2010, 11, 31, 23, 59, 59));
  test.end();
});

tape("timeYear.floor(date) correctly handles years in the first century", function(test) {
  test.deepEqual(time.timeYear.floor(date.local(0011, 10, 06, 07)), date.local(0011, 00, 01));
  test.end();
});

tape("timeYear.ceil(date) returns years", function(test) {
  test.deepEqual(time.timeYear.ceil(date.local(2010, 11, 31, 23, 59, 59)), date.local(2011, 00, 01));
  test.deepEqual(time.timeYear.ceil(date.local(2011, 00, 01, 00, 00, 00)), date.local(2011, 00, 01));
  test.deepEqual(time.timeYear.ceil(date.local(2011, 00, 01, 00, 00, 01)), date.local(2012, 00, 01));
  test.end();
});

tape("timeYear.offset(date, count) does not modify the passed-in date", function(test) {
  var d = date.local(2010, 11, 31, 23, 59, 59, 999);
  time.timeYear.offset(d, +1);
  test.deepEqual(d, date.local(2010, 11, 31, 23, 59, 59, 999));
  test.end();
});

tape("timeYear.offset(date, count) does not round the passed-in-date", function(test) {
  test.deepEqual(time.timeYear.offset(date.local(2010, 11, 31, 23, 59, 59, 999), +1), date.local(2011, 11, 31, 23, 59, 59, 999));
  test.deepEqual(time.timeYear.offset(date.local(2010, 11, 31, 23, 59, 59, 456), -2), date.local(2008, 11, 31, 23, 59, 59, 456));
  test.end();
});

tape("timeYear.offset(date, count) allows negative offsets", function(test) {
  test.deepEqual(time.timeYear.offset(date.local(2010, 11, 01), -1), date.local(2009, 11, 01));
  test.deepEqual(time.timeYear.offset(date.local(2011, 00, 01), -2), date.local(2009, 00, 01));
  test.deepEqual(time.timeYear.offset(date.local(2011, 00, 01), -1), date.local(2010, 00, 01));
  test.end();
});

tape("timeYear.offset(date, count) allows positive offsets", function(test) {
  test.deepEqual(time.timeYear.offset(date.local(2009, 11, 01), +1), date.local(2010, 11, 01));
  test.deepEqual(time.timeYear.offset(date.local(2009, 00, 01), +2), date.local(2011, 00, 01));
  test.deepEqual(time.timeYear.offset(date.local(2010, 00, 01), +1), date.local(2011, 00, 01));
  test.end();
});

tape("timeYear.offset(date, count) allows zero offset", function(test) {
  test.deepEqual(time.timeYear.offset(date.local(2010, 11, 31, 23, 59, 59, 999), 0), date.local(2010, 11, 31, 23, 59, 59, 999));
  test.deepEqual(time.timeYear.offset(date.local(2010, 11, 31, 23, 59, 58, 000), 0), date.local(2010, 11, 31, 23, 59, 58, 000));
  test.end();
});

tape("timeYear.every(step) returns every stepth year, starting with year zero", function(test) {
  test.deepEqual(time.timeYear.every(5).range(date.local(2008), date.local(2023)), [date.local(2010), date.local(2015), date.local(2020)]);
  test.end();
});

tape("timeYear.range(start, stop) returns years", function(test) {
  test.deepEqual(time.timeYear.range(date.local(2010, 0, 1), date.local(2013, 0, 1)), [
    date.local(2010, 0, 1),
    date.local(2011, 0, 1),
    date.local(2012, 0, 1)
  ]);
  test.end();
});

tape("timeYear.range(start, stop) has an inclusive lower bound", function(test) {
  test.deepEqual(time.timeYear.range(date.local(2010, 0, 1), date.local(2013, 0, 1))[0], date.local(2010, 0, 1));
  test.end();
});

tape("timeYear.range(start, stop) has an exclusive upper bound", function(test) {
  test.deepEqual(time.timeYear.range(date.local(2010, 0, 1), date.local(2013, 0, 1))[2], date.local(2012, 0, 1));
  test.end();
});

tape("timeYear.range(start, stop, step) can skip years", function(test) {
  test.deepEqual(time.timeYear.range(date.local(2009, 0, 1), date.local(2029, 0, 1), 5), [
    date.local(2009, 0, 1),
    date.local(2014, 0, 1),
    date.local(2019, 0, 1),
    date.local(2024, 0, 1)
  ]);
  test.end();
});
