#ifndef _PDU_MPLS_H
#define _PDU_MPLS_H 1

/* pdu-mpls.h
 
   Function prototypes and variables used by the builder of MPLS PDUs.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Bit fields in an MPLS Label Stack Entry (LSE). */
#define LSE_LABEL   (0xfffff << 12) /* Label Value */
#define LABEL_SHIFT 12
#define LSE_EXP	    (0x7 << 9)	    /* Experimental Use */
#define EXP_SHIFT   9
#define LSE_S	    (1 << 8)	    /* Bottom of Stack */
#define S_SHIFT	    8
#define LSE_TTL	    (0xff << 0)	    /* Time to Live */

#endif /* _PDU_MPLS_H */
