/* $Id: GC_Sequence.hpp 398186 2013-05-03 15:42:06Z kumarv2 $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_Sequence.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: GC_Sequence_.hpp


#ifndef INTERNAL_GPIPE_OBJECTS_GENOMECOLL_GC_SEQUENCE_HPP
#define INTERNAL_GPIPE_OBJECTS_GENOMECOLL_GC_SEQUENCE_HPP


// generated includes
#include <objects/genomecoll/GC_Sequence_.hpp>

#include <objects/genomecoll/GC_TaggedSequences.hpp>
#include <objects/genomecoll/GC_TypedSeqId.hpp>
#include <objects/genomecoll/GC_SeqIdAlias.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CGC_Assembly;
class CGC_AssemblyUnit;
class CGC_Replicon;
class CGC_Sequence;

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENOME_COLLECTION_EXPORT CGC_Sequence : public CGC_Sequence_Base
{
    typedef CGC_Sequence_Base Tparent;
    friend class CGC_Assembly;
    friend class CGC_Replicon;
public:
    // constructor
    CGC_Sequence(void);
    // destructor
    ~CGC_Sequence(void);

    /// Access the assembly unit the sequence belongs to
    CConstRef<CGC_AssemblyUnit> GetAssemblyUnit() const;

    /// Access the most specific full assembly the sequence belongs to
    /// This is needed because assemblies are packaged as sets of assemblies;
    /// knowing the unit is not always enough
    CConstRef<CGC_Assembly> GetFullAssembly() const;

    /// Access the replicon the sequence belongs to
    CConstRef<CGC_Replicon> GetReplicon() const;

    /// Access the parent sequence of this sequence
    CConstRef<CGC_Sequence> GetParent() const;

    /// Access the top-most parent sequence of this sequence
    CConstRef<CGC_Sequence> GetTopLevelParent() const;

    /// Access the relationship to the parent
    CGC_TaggedSequences::TState GetParentRelation() const;

    CConstRef<CSeq_id> GetSynonymSeq_id( CGC_TypedSeqId::E_Choice type, CGC_SeqIdAlias::E_AliasTypes ) const;
	CConstRef<CSeq_id> GetSubmitterName( ) const;
	
	bool HasRole(int Role) const;

protected:
    CGC_Assembly*     m_Assembly;
    CGC_AssemblyUnit* m_AssemblyUnit;
    CGC_Replicon*     m_Replicon;
    CGC_Sequence*     m_ParentSequence;
    CGC_TaggedSequences::TState m_ParentRel;

private:
    // Prohibit copy constructor and assignment operator
    CGC_Sequence(const CGC_Sequence& value);
    CGC_Sequence& operator=(const CGC_Sequence& value);

};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // INTERNAL_GPIPE_OBJECTS_GENOMECOLL_GC_SEQUENCE_HPP
/* Original file checksum: lines: 86, chars: 2546, CRC32: bcfce2e6 */
