/* $Id: Seq_table.hpp 457991 2015-01-29 19:26:03Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_table.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Seq_table_.hpp


#ifndef OBJECTS_SEQTABLE_SEQ_TABLE_HPP
#define OBJECTS_SEQTABLE_SEQ_TABLE_HPP


// generated includes
#include <objects/seqtable/Seq_table_.hpp>

// generated classes


#include <objects/seqtable/SeqTable_column_info.hpp>

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeq_table : public CSeq_table_Base
{
    typedef CSeq_table_Base Tparent;
public:
    // constructor
    CSeq_table(void);
    // destructor
    ~CSeq_table(void);

    typedef CSeqTable_column_info::EField_id TColumnId;
    const CSeqTable_column& GetColumn(CTempString column_name) const;
    const CSeqTable_column& GetColumn(TColumnId column_id) const;
    const CSeqTable_column& GetColumn(TColumnId column_id,
                                      CTempString column_name) const;

    static string GetIdName(TColumnId column_id);

private:
    // Prohibit copy constructor and assignment operator
    CSeq_table(const CSeq_table& value);
    CSeq_table& operator=(const CSeq_table& value);

};

/////////////////// CSeq_table inline methods

// constructor
inline
CSeq_table::CSeq_table(void)
{
}


/////////////////// end of CSeq_table inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQ_TABLE_HPP
