/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.io.IOException;
import java.net.InetAddress;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;

public class ServiceAuthorizationManager {
    private static final String HADOOP_POLICY_FILE = "hadoop-policy.xml";
    private static final Log LOG = LogFactory.getLog(ServiceAuthorizationManager.class);
    private static Map<Class<?>, AccessControlList> protocolToAcl = new IdentityHashMap();
    @Deprecated
    public static final String SERVICE_AUTHORIZATION_CONFIG = "hadoop.security.authorization";
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + ServiceAuthorizationManager.class.getName()));
    private static final String AUTHZ_SUCCESSFULL_FOR = "Authorization successfull for ";
    private static final String AUTHZ_FAILED_FOR = "Authorization failed for ";

    public static void authorize(UserGroupInformation user, Class<?> protocol, Configuration conf, InetAddress addr) throws AuthorizationException {
        String clientKey;
        AccessControlList acl = protocolToAcl.get(protocol);
        if (acl == null) {
            throw new AuthorizationException("Protocol " + protocol + " is not known.");
        }
        KerberosInfo krbInfo = protocol.getAnnotation(KerberosInfo.class);
        String clientPrincipal = null;
        if (krbInfo != null && (clientKey = krbInfo.clientPrincipal()) != null && !clientKey.equals("")) {
            try {
                clientPrincipal = SecurityUtil.getServerPrincipal(conf.get(clientKey), addr);
            }
            catch (IOException e) {
                throw (AuthorizationException)new AuthorizationException("Can't figure out Kerberos principal name for connection from " + addr + " for user=" + user + " protocol=" + protocol).initCause(e);
            }
        }
        if (clientPrincipal != null && !clientPrincipal.equals(user.getUserName()) || !acl.isUserAllowed(user)) {
            AUDITLOG.warn((Object)(AUTHZ_FAILED_FOR + user + " for protocol=" + protocol + ", expected client Kerberos principal is " + clientPrincipal));
            throw new AuthorizationException("User " + user + " is not authorized for protocol " + protocol + ", expected client Kerberos principal is " + clientPrincipal);
        }
        AUDITLOG.info((Object)(AUTHZ_SUCCESSFULL_FOR + user + " for protocol=" + protocol));
    }

    public static synchronized void refresh(Configuration conf, PolicyProvider provider) {
        String policyFile = System.getProperty("hadoop.policy.file", HADOOP_POLICY_FILE);
        Configuration policyConf = new Configuration(conf);
        policyConf.addResource(policyFile);
        IdentityHashMap newAcls = new IdentityHashMap();
        Service[] services = provider.getServices();
        if (services != null) {
            for (Service service : services) {
                AccessControlList acl = new AccessControlList(policyConf.get(service.getServiceKey(), "*"));
                newAcls.put(service.getProtocol(), acl);
            }
        }
        protocolToAcl = newAcls;
    }
}

