"use strict";

var helpers = require("../../helpers/helpers");

exports["Pacific/Norfolk"] = {

	"guess:by:offset" : helpers.makeTestGuess("Pacific/Norfolk", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Pacific/Norfolk", { abbr: true }),

	"1900" : helpers.makeTestYear("Pacific/Norfolk", [
		["1900-12-31T12:48:08+00:00", "00:00:08", "+1112", -672]
	]),

	"1950" : helpers.makeTestYear("Pacific/Norfolk", [
		["1950-12-31T12:47:59+00:00", "23:59:59", "+1112", -672],
		["1950-12-31T12:48:00+00:00", "00:18:00", "+1130", -690]
	]),

	"1974" : helpers.makeTestYear("Pacific/Norfolk", [
		["1974-10-26T14:29:59+00:00", "01:59:59", "+1130", -690],
		["1974-10-26T14:30:00+00:00", "03:00:00", "+1230", -750]
	]),

	"1975" : helpers.makeTestYear("Pacific/Norfolk", [
		["1975-03-01T14:29:59+00:00", "02:59:59", "+1230", -750],
		["1975-03-01T14:30:00+00:00", "02:00:00", "+1130", -690]
	]),

	"2015" : helpers.makeTestYear("Pacific/Norfolk", [
		["2015-10-03T14:29:59+00:00", "01:59:59", "+1130", -690],
		["2015-10-03T14:30:00+00:00", "01:30:00", "+11", -660]
	]),

	"2019" : helpers.makeTestYear("Pacific/Norfolk", [
		["2019-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2019-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2020" : helpers.makeTestYear("Pacific/Norfolk", [
		["2020-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2020-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2020-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2020-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2021" : helpers.makeTestYear("Pacific/Norfolk", [
		["2021-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2021-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2021-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2021-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2022" : helpers.makeTestYear("Pacific/Norfolk", [
		["2022-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2022-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2022-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2022-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2023" : helpers.makeTestYear("Pacific/Norfolk", [
		["2023-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2023-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2023-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2023-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2024" : helpers.makeTestYear("Pacific/Norfolk", [
		["2024-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2024-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2024-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2024-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2025" : helpers.makeTestYear("Pacific/Norfolk", [
		["2025-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2025-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2025-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2025-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2026" : helpers.makeTestYear("Pacific/Norfolk", [
		["2026-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2026-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2026-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2026-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2027" : helpers.makeTestYear("Pacific/Norfolk", [
		["2027-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2027-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2027-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2027-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2028" : helpers.makeTestYear("Pacific/Norfolk", [
		["2028-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2028-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2028-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2028-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2029" : helpers.makeTestYear("Pacific/Norfolk", [
		["2029-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2029-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2029-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2029-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2030" : helpers.makeTestYear("Pacific/Norfolk", [
		["2030-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2030-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2030-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2030-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2031" : helpers.makeTestYear("Pacific/Norfolk", [
		["2031-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2031-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2031-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2031-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2032" : helpers.makeTestYear("Pacific/Norfolk", [
		["2032-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2032-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2032-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2032-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2033" : helpers.makeTestYear("Pacific/Norfolk", [
		["2033-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2033-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2033-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2033-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2034" : helpers.makeTestYear("Pacific/Norfolk", [
		["2034-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2034-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2034-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2034-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2035" : helpers.makeTestYear("Pacific/Norfolk", [
		["2035-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2035-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2035-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2035-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2036" : helpers.makeTestYear("Pacific/Norfolk", [
		["2036-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2036-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2036-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2036-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2037" : helpers.makeTestYear("Pacific/Norfolk", [
		["2037-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2037-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2037-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2037-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2038" : helpers.makeTestYear("Pacific/Norfolk", [
		["2038-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2038-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2038-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2038-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2039" : helpers.makeTestYear("Pacific/Norfolk", [
		["2039-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2039-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2039-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2039-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2040" : helpers.makeTestYear("Pacific/Norfolk", [
		["2040-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2040-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2040-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2040-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2041" : helpers.makeTestYear("Pacific/Norfolk", [
		["2041-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2041-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2041-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2041-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2042" : helpers.makeTestYear("Pacific/Norfolk", [
		["2042-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2042-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2042-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2042-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2043" : helpers.makeTestYear("Pacific/Norfolk", [
		["2043-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2043-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2043-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2043-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2044" : helpers.makeTestYear("Pacific/Norfolk", [
		["2044-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2044-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2044-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2044-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2045" : helpers.makeTestYear("Pacific/Norfolk", [
		["2045-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2045-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2045-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2045-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2046" : helpers.makeTestYear("Pacific/Norfolk", [
		["2046-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2046-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2046-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2046-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2047" : helpers.makeTestYear("Pacific/Norfolk", [
		["2047-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2047-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2047-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2047-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2048" : helpers.makeTestYear("Pacific/Norfolk", [
		["2048-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2048-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2048-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2048-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2049" : helpers.makeTestYear("Pacific/Norfolk", [
		["2049-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2049-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2049-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2049-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2050" : helpers.makeTestYear("Pacific/Norfolk", [
		["2050-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2050-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2050-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2050-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2051" : helpers.makeTestYear("Pacific/Norfolk", [
		["2051-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2051-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2051-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2051-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2052" : helpers.makeTestYear("Pacific/Norfolk", [
		["2052-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2052-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2052-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2052-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2053" : helpers.makeTestYear("Pacific/Norfolk", [
		["2053-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2053-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2053-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2053-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2054" : helpers.makeTestYear("Pacific/Norfolk", [
		["2054-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2054-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2054-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2054-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2055" : helpers.makeTestYear("Pacific/Norfolk", [
		["2055-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2055-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2055-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2055-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2056" : helpers.makeTestYear("Pacific/Norfolk", [
		["2056-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2056-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2056-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2056-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2057" : helpers.makeTestYear("Pacific/Norfolk", [
		["2057-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2057-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2057-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2057-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2058" : helpers.makeTestYear("Pacific/Norfolk", [
		["2058-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2058-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2058-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2058-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2059" : helpers.makeTestYear("Pacific/Norfolk", [
		["2059-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2059-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2059-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2059-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2060" : helpers.makeTestYear("Pacific/Norfolk", [
		["2060-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2060-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2060-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2060-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2061" : helpers.makeTestYear("Pacific/Norfolk", [
		["2061-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2061-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2061-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2061-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2062" : helpers.makeTestYear("Pacific/Norfolk", [
		["2062-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2062-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2062-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2062-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2063" : helpers.makeTestYear("Pacific/Norfolk", [
		["2063-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2063-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2063-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2063-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2064" : helpers.makeTestYear("Pacific/Norfolk", [
		["2064-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2064-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2064-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2064-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2065" : helpers.makeTestYear("Pacific/Norfolk", [
		["2065-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2065-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2065-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2065-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2066" : helpers.makeTestYear("Pacific/Norfolk", [
		["2066-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2066-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2066-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2066-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2067" : helpers.makeTestYear("Pacific/Norfolk", [
		["2067-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2067-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2067-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2067-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2068" : helpers.makeTestYear("Pacific/Norfolk", [
		["2068-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2068-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2068-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2068-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2069" : helpers.makeTestYear("Pacific/Norfolk", [
		["2069-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2069-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2069-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2069-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2070" : helpers.makeTestYear("Pacific/Norfolk", [
		["2070-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2070-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2070-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2070-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2071" : helpers.makeTestYear("Pacific/Norfolk", [
		["2071-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2071-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2071-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2071-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2072" : helpers.makeTestYear("Pacific/Norfolk", [
		["2072-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2072-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2072-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2072-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2073" : helpers.makeTestYear("Pacific/Norfolk", [
		["2073-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2073-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2073-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2073-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2074" : helpers.makeTestYear("Pacific/Norfolk", [
		["2074-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2074-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2074-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2074-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2075" : helpers.makeTestYear("Pacific/Norfolk", [
		["2075-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2075-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2075-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2075-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2076" : helpers.makeTestYear("Pacific/Norfolk", [
		["2076-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2076-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2076-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2076-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2077" : helpers.makeTestYear("Pacific/Norfolk", [
		["2077-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2077-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2077-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2077-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2078" : helpers.makeTestYear("Pacific/Norfolk", [
		["2078-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2078-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2078-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2078-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2079" : helpers.makeTestYear("Pacific/Norfolk", [
		["2079-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2079-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2079-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2079-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2080" : helpers.makeTestYear("Pacific/Norfolk", [
		["2080-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2080-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2080-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2080-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2081" : helpers.makeTestYear("Pacific/Norfolk", [
		["2081-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2081-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2081-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2081-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2082" : helpers.makeTestYear("Pacific/Norfolk", [
		["2082-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2082-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2082-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2082-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2083" : helpers.makeTestYear("Pacific/Norfolk", [
		["2083-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2083-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2083-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2083-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2084" : helpers.makeTestYear("Pacific/Norfolk", [
		["2084-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2084-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2084-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2084-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2085" : helpers.makeTestYear("Pacific/Norfolk", [
		["2085-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2085-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2085-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2085-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2086" : helpers.makeTestYear("Pacific/Norfolk", [
		["2086-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2086-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2086-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2086-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2087" : helpers.makeTestYear("Pacific/Norfolk", [
		["2087-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2087-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2087-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2087-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2088" : helpers.makeTestYear("Pacific/Norfolk", [
		["2088-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2088-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2088-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2088-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2089" : helpers.makeTestYear("Pacific/Norfolk", [
		["2089-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2089-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2089-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2089-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2090" : helpers.makeTestYear("Pacific/Norfolk", [
		["2090-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2090-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2090-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2090-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2091" : helpers.makeTestYear("Pacific/Norfolk", [
		["2091-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2091-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2091-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2091-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2092" : helpers.makeTestYear("Pacific/Norfolk", [
		["2092-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2092-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2092-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2092-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2093" : helpers.makeTestYear("Pacific/Norfolk", [
		["2093-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2093-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2093-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2093-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2094" : helpers.makeTestYear("Pacific/Norfolk", [
		["2094-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2094-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2094-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2094-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2095" : helpers.makeTestYear("Pacific/Norfolk", [
		["2095-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2095-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2095-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2095-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2096" : helpers.makeTestYear("Pacific/Norfolk", [
		["2096-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2096-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2096-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2096-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2097" : helpers.makeTestYear("Pacific/Norfolk", [
		["2097-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2097-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2097-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2097-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2098" : helpers.makeTestYear("Pacific/Norfolk", [
		["2098-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2098-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2098-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2098-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2099" : helpers.makeTestYear("Pacific/Norfolk", [
		["2099-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2099-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2099-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2099-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2100" : helpers.makeTestYear("Pacific/Norfolk", [
		["2100-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2100-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2100-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2100-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2101" : helpers.makeTestYear("Pacific/Norfolk", [
		["2101-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2101-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2101-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2101-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2102" : helpers.makeTestYear("Pacific/Norfolk", [
		["2102-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2102-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2102-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2102-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2103" : helpers.makeTestYear("Pacific/Norfolk", [
		["2103-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2103-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2103-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2103-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2104" : helpers.makeTestYear("Pacific/Norfolk", [
		["2104-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2104-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2104-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2104-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2105" : helpers.makeTestYear("Pacific/Norfolk", [
		["2105-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2105-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2105-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2105-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2106" : helpers.makeTestYear("Pacific/Norfolk", [
		["2106-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2106-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2106-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2106-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2107" : helpers.makeTestYear("Pacific/Norfolk", [
		["2107-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2107-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2107-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2107-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2108" : helpers.makeTestYear("Pacific/Norfolk", [
		["2108-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2108-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2108-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2108-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2109" : helpers.makeTestYear("Pacific/Norfolk", [
		["2109-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2109-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2109-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2109-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2110" : helpers.makeTestYear("Pacific/Norfolk", [
		["2110-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2110-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2110-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2110-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2111" : helpers.makeTestYear("Pacific/Norfolk", [
		["2111-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2111-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2111-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2111-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2112" : helpers.makeTestYear("Pacific/Norfolk", [
		["2112-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2112-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2112-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2112-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2113" : helpers.makeTestYear("Pacific/Norfolk", [
		["2113-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2113-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2113-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2113-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2114" : helpers.makeTestYear("Pacific/Norfolk", [
		["2114-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2114-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2114-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2114-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2115" : helpers.makeTestYear("Pacific/Norfolk", [
		["2115-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2115-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2115-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2115-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2116" : helpers.makeTestYear("Pacific/Norfolk", [
		["2116-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2116-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2116-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2116-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2117" : helpers.makeTestYear("Pacific/Norfolk", [
		["2117-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2117-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2117-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2117-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2118" : helpers.makeTestYear("Pacific/Norfolk", [
		["2118-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2118-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2118-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2118-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2119" : helpers.makeTestYear("Pacific/Norfolk", [
		["2119-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2119-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2119-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2119-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2120" : helpers.makeTestYear("Pacific/Norfolk", [
		["2120-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2120-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2120-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2120-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2121" : helpers.makeTestYear("Pacific/Norfolk", [
		["2121-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2121-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2121-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2121-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2122" : helpers.makeTestYear("Pacific/Norfolk", [
		["2122-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2122-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2122-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2122-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2123" : helpers.makeTestYear("Pacific/Norfolk", [
		["2123-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2123-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2123-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2123-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2124" : helpers.makeTestYear("Pacific/Norfolk", [
		["2124-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2124-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2124-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2124-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2125" : helpers.makeTestYear("Pacific/Norfolk", [
		["2125-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2125-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2125-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2125-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2126" : helpers.makeTestYear("Pacific/Norfolk", [
		["2126-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2126-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2126-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2126-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2127" : helpers.makeTestYear("Pacific/Norfolk", [
		["2127-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2127-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2127-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2127-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2128" : helpers.makeTestYear("Pacific/Norfolk", [
		["2128-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2128-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2128-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2128-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2129" : helpers.makeTestYear("Pacific/Norfolk", [
		["2129-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2129-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2129-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2129-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2130" : helpers.makeTestYear("Pacific/Norfolk", [
		["2130-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2130-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2130-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2130-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2131" : helpers.makeTestYear("Pacific/Norfolk", [
		["2131-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2131-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2131-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2131-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2132" : helpers.makeTestYear("Pacific/Norfolk", [
		["2132-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2132-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2132-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2132-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2133" : helpers.makeTestYear("Pacific/Norfolk", [
		["2133-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2133-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2133-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2133-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2134" : helpers.makeTestYear("Pacific/Norfolk", [
		["2134-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2134-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2134-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2134-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2135" : helpers.makeTestYear("Pacific/Norfolk", [
		["2135-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2135-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2135-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2135-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2136" : helpers.makeTestYear("Pacific/Norfolk", [
		["2136-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2136-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2136-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2136-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2137" : helpers.makeTestYear("Pacific/Norfolk", [
		["2137-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2137-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2137-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2137-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2138" : helpers.makeTestYear("Pacific/Norfolk", [
		["2138-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2138-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2138-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2138-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2139" : helpers.makeTestYear("Pacific/Norfolk", [
		["2139-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2139-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2139-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2139-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2140" : helpers.makeTestYear("Pacific/Norfolk", [
		["2140-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2140-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2140-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2140-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2141" : helpers.makeTestYear("Pacific/Norfolk", [
		["2141-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2141-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2141-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2141-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2142" : helpers.makeTestYear("Pacific/Norfolk", [
		["2142-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2142-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2142-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2142-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2143" : helpers.makeTestYear("Pacific/Norfolk", [
		["2143-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2143-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2143-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2143-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2144" : helpers.makeTestYear("Pacific/Norfolk", [
		["2144-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2144-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2144-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2144-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2145" : helpers.makeTestYear("Pacific/Norfolk", [
		["2145-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2145-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2145-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2145-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2146" : helpers.makeTestYear("Pacific/Norfolk", [
		["2146-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2146-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2146-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2146-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2147" : helpers.makeTestYear("Pacific/Norfolk", [
		["2147-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2147-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2147-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2147-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2148" : helpers.makeTestYear("Pacific/Norfolk", [
		["2148-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2148-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2148-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2148-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2149" : helpers.makeTestYear("Pacific/Norfolk", [
		["2149-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2149-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2149-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2149-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2150" : helpers.makeTestYear("Pacific/Norfolk", [
		["2150-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2150-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2150-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2150-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2151" : helpers.makeTestYear("Pacific/Norfolk", [
		["2151-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2151-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2151-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2151-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2152" : helpers.makeTestYear("Pacific/Norfolk", [
		["2152-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2152-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2152-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2152-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2153" : helpers.makeTestYear("Pacific/Norfolk", [
		["2153-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2153-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2153-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2153-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2154" : helpers.makeTestYear("Pacific/Norfolk", [
		["2154-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2154-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2154-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2154-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2155" : helpers.makeTestYear("Pacific/Norfolk", [
		["2155-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2155-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2155-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2155-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2156" : helpers.makeTestYear("Pacific/Norfolk", [
		["2156-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2156-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2156-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2156-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2157" : helpers.makeTestYear("Pacific/Norfolk", [
		["2157-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2157-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2157-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2157-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2158" : helpers.makeTestYear("Pacific/Norfolk", [
		["2158-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2158-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2158-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2158-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2159" : helpers.makeTestYear("Pacific/Norfolk", [
		["2159-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2159-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2159-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2159-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2160" : helpers.makeTestYear("Pacific/Norfolk", [
		["2160-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2160-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2160-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2160-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2161" : helpers.makeTestYear("Pacific/Norfolk", [
		["2161-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2161-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2161-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2161-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2162" : helpers.makeTestYear("Pacific/Norfolk", [
		["2162-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2162-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2162-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2162-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2163" : helpers.makeTestYear("Pacific/Norfolk", [
		["2163-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2163-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2163-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2163-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2164" : helpers.makeTestYear("Pacific/Norfolk", [
		["2164-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2164-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2164-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2164-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2165" : helpers.makeTestYear("Pacific/Norfolk", [
		["2165-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2165-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2165-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2165-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2166" : helpers.makeTestYear("Pacific/Norfolk", [
		["2166-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2166-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2166-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2166-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2167" : helpers.makeTestYear("Pacific/Norfolk", [
		["2167-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2167-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2167-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2167-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2168" : helpers.makeTestYear("Pacific/Norfolk", [
		["2168-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2168-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2168-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2168-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2169" : helpers.makeTestYear("Pacific/Norfolk", [
		["2169-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2169-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2169-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2169-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2170" : helpers.makeTestYear("Pacific/Norfolk", [
		["2170-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2170-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2170-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2170-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2171" : helpers.makeTestYear("Pacific/Norfolk", [
		["2171-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2171-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2171-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2171-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2172" : helpers.makeTestYear("Pacific/Norfolk", [
		["2172-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2172-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2172-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2172-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2173" : helpers.makeTestYear("Pacific/Norfolk", [
		["2173-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2173-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2173-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2173-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2174" : helpers.makeTestYear("Pacific/Norfolk", [
		["2174-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2174-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2174-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2174-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2175" : helpers.makeTestYear("Pacific/Norfolk", [
		["2175-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2175-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2175-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2175-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2176" : helpers.makeTestYear("Pacific/Norfolk", [
		["2176-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2176-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2176-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2176-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2177" : helpers.makeTestYear("Pacific/Norfolk", [
		["2177-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2177-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2177-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2177-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2178" : helpers.makeTestYear("Pacific/Norfolk", [
		["2178-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2178-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2178-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2178-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2179" : helpers.makeTestYear("Pacific/Norfolk", [
		["2179-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2179-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2179-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2179-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2180" : helpers.makeTestYear("Pacific/Norfolk", [
		["2180-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2180-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2180-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2180-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2181" : helpers.makeTestYear("Pacific/Norfolk", [
		["2181-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2181-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2181-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2181-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2182" : helpers.makeTestYear("Pacific/Norfolk", [
		["2182-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2182-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2182-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2182-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2183" : helpers.makeTestYear("Pacific/Norfolk", [
		["2183-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2183-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2183-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2183-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2184" : helpers.makeTestYear("Pacific/Norfolk", [
		["2184-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2184-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2184-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2184-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2185" : helpers.makeTestYear("Pacific/Norfolk", [
		["2185-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2185-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2185-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2185-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2186" : helpers.makeTestYear("Pacific/Norfolk", [
		["2186-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2186-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2186-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2186-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2187" : helpers.makeTestYear("Pacific/Norfolk", [
		["2187-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2187-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2187-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2187-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2188" : helpers.makeTestYear("Pacific/Norfolk", [
		["2188-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2188-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2188-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2188-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2189" : helpers.makeTestYear("Pacific/Norfolk", [
		["2189-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2189-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2189-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2189-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2190" : helpers.makeTestYear("Pacific/Norfolk", [
		["2190-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2190-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2190-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2190-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2191" : helpers.makeTestYear("Pacific/Norfolk", [
		["2191-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2191-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2191-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2191-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2192" : helpers.makeTestYear("Pacific/Norfolk", [
		["2192-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2192-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2192-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2192-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2193" : helpers.makeTestYear("Pacific/Norfolk", [
		["2193-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2193-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2193-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2193-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2194" : helpers.makeTestYear("Pacific/Norfolk", [
		["2194-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2194-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2194-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2194-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2195" : helpers.makeTestYear("Pacific/Norfolk", [
		["2195-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2195-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2195-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2195-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2196" : helpers.makeTestYear("Pacific/Norfolk", [
		["2196-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2196-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2196-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2196-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2197" : helpers.makeTestYear("Pacific/Norfolk", [
		["2197-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2197-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2197-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2197-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2198" : helpers.makeTestYear("Pacific/Norfolk", [
		["2198-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2198-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2198-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2198-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2199" : helpers.makeTestYear("Pacific/Norfolk", [
		["2199-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2199-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2199-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2199-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2200" : helpers.makeTestYear("Pacific/Norfolk", [
		["2200-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2200-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2200-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2200-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2201" : helpers.makeTestYear("Pacific/Norfolk", [
		["2201-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2201-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2201-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2201-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2202" : helpers.makeTestYear("Pacific/Norfolk", [
		["2202-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2202-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2202-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2202-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2203" : helpers.makeTestYear("Pacific/Norfolk", [
		["2203-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2203-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2203-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2203-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2204" : helpers.makeTestYear("Pacific/Norfolk", [
		["2204-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2204-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2204-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2204-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2205" : helpers.makeTestYear("Pacific/Norfolk", [
		["2205-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2205-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2205-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2205-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2206" : helpers.makeTestYear("Pacific/Norfolk", [
		["2206-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2206-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2206-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2206-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2207" : helpers.makeTestYear("Pacific/Norfolk", [
		["2207-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2207-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2207-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2207-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2208" : helpers.makeTestYear("Pacific/Norfolk", [
		["2208-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2208-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2208-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2208-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2209" : helpers.makeTestYear("Pacific/Norfolk", [
		["2209-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2209-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2209-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2209-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2210" : helpers.makeTestYear("Pacific/Norfolk", [
		["2210-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2210-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2210-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2210-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2211" : helpers.makeTestYear("Pacific/Norfolk", [
		["2211-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2211-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2211-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2211-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2212" : helpers.makeTestYear("Pacific/Norfolk", [
		["2212-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2212-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2212-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2212-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2213" : helpers.makeTestYear("Pacific/Norfolk", [
		["2213-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2213-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2213-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2213-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2214" : helpers.makeTestYear("Pacific/Norfolk", [
		["2214-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2214-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2214-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2214-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2215" : helpers.makeTestYear("Pacific/Norfolk", [
		["2215-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2215-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2215-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2215-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2216" : helpers.makeTestYear("Pacific/Norfolk", [
		["2216-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2216-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2216-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2216-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2217" : helpers.makeTestYear("Pacific/Norfolk", [
		["2217-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2217-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2217-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2217-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2218" : helpers.makeTestYear("Pacific/Norfolk", [
		["2218-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2218-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2218-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2218-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2219" : helpers.makeTestYear("Pacific/Norfolk", [
		["2219-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2219-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2219-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2219-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2220" : helpers.makeTestYear("Pacific/Norfolk", [
		["2220-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2220-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2220-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2220-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2221" : helpers.makeTestYear("Pacific/Norfolk", [
		["2221-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2221-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2221-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2221-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2222" : helpers.makeTestYear("Pacific/Norfolk", [
		["2222-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2222-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2222-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2222-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2223" : helpers.makeTestYear("Pacific/Norfolk", [
		["2223-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2223-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2223-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2223-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2224" : helpers.makeTestYear("Pacific/Norfolk", [
		["2224-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2224-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2224-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2224-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2225" : helpers.makeTestYear("Pacific/Norfolk", [
		["2225-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2225-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2225-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2225-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2226" : helpers.makeTestYear("Pacific/Norfolk", [
		["2226-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2226-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2226-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2226-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2227" : helpers.makeTestYear("Pacific/Norfolk", [
		["2227-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2227-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2227-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2227-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2228" : helpers.makeTestYear("Pacific/Norfolk", [
		["2228-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2228-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2228-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2228-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2229" : helpers.makeTestYear("Pacific/Norfolk", [
		["2229-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2229-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2229-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2229-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2230" : helpers.makeTestYear("Pacific/Norfolk", [
		["2230-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2230-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2230-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2230-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2231" : helpers.makeTestYear("Pacific/Norfolk", [
		["2231-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2231-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2231-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2231-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2232" : helpers.makeTestYear("Pacific/Norfolk", [
		["2232-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2232-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2232-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2232-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2233" : helpers.makeTestYear("Pacific/Norfolk", [
		["2233-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2233-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2233-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2233-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2234" : helpers.makeTestYear("Pacific/Norfolk", [
		["2234-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2234-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2234-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2234-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2235" : helpers.makeTestYear("Pacific/Norfolk", [
		["2235-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2235-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2235-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2235-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2236" : helpers.makeTestYear("Pacific/Norfolk", [
		["2236-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2236-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2236-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2236-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2237" : helpers.makeTestYear("Pacific/Norfolk", [
		["2237-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2237-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2237-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2237-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2238" : helpers.makeTestYear("Pacific/Norfolk", [
		["2238-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2238-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2238-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2238-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2239" : helpers.makeTestYear("Pacific/Norfolk", [
		["2239-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2239-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2239-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2239-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2240" : helpers.makeTestYear("Pacific/Norfolk", [
		["2240-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2240-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2240-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2240-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2241" : helpers.makeTestYear("Pacific/Norfolk", [
		["2241-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2241-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2241-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2241-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2242" : helpers.makeTestYear("Pacific/Norfolk", [
		["2242-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2242-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2242-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2242-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2243" : helpers.makeTestYear("Pacific/Norfolk", [
		["2243-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2243-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2243-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2243-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2244" : helpers.makeTestYear("Pacific/Norfolk", [
		["2244-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2244-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2244-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2244-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2245" : helpers.makeTestYear("Pacific/Norfolk", [
		["2245-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2245-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2245-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2245-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2246" : helpers.makeTestYear("Pacific/Norfolk", [
		["2246-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2246-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2246-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2246-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2247" : helpers.makeTestYear("Pacific/Norfolk", [
		["2247-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2247-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2247-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2247-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2248" : helpers.makeTestYear("Pacific/Norfolk", [
		["2248-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2248-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2248-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2248-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2249" : helpers.makeTestYear("Pacific/Norfolk", [
		["2249-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2249-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2249-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2249-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2250" : helpers.makeTestYear("Pacific/Norfolk", [
		["2250-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2250-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2250-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2250-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2251" : helpers.makeTestYear("Pacific/Norfolk", [
		["2251-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2251-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2251-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2251-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2252" : helpers.makeTestYear("Pacific/Norfolk", [
		["2252-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2252-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2252-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2252-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2253" : helpers.makeTestYear("Pacific/Norfolk", [
		["2253-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2253-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2253-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2253-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2254" : helpers.makeTestYear("Pacific/Norfolk", [
		["2254-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2254-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2254-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2254-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2255" : helpers.makeTestYear("Pacific/Norfolk", [
		["2255-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2255-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2255-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2255-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2256" : helpers.makeTestYear("Pacific/Norfolk", [
		["2256-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2256-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2256-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2256-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2257" : helpers.makeTestYear("Pacific/Norfolk", [
		["2257-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2257-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2257-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2257-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2258" : helpers.makeTestYear("Pacific/Norfolk", [
		["2258-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2258-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2258-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2258-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2259" : helpers.makeTestYear("Pacific/Norfolk", [
		["2259-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2259-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2259-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2259-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2260" : helpers.makeTestYear("Pacific/Norfolk", [
		["2260-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2260-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2260-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2260-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2261" : helpers.makeTestYear("Pacific/Norfolk", [
		["2261-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2261-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2261-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2261-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2262" : helpers.makeTestYear("Pacific/Norfolk", [
		["2262-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2262-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2262-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2262-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2263" : helpers.makeTestYear("Pacific/Norfolk", [
		["2263-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2263-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2263-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2263-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2264" : helpers.makeTestYear("Pacific/Norfolk", [
		["2264-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2264-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2264-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2264-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2265" : helpers.makeTestYear("Pacific/Norfolk", [
		["2265-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2265-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2265-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2265-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2266" : helpers.makeTestYear("Pacific/Norfolk", [
		["2266-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2266-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2266-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2266-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2267" : helpers.makeTestYear("Pacific/Norfolk", [
		["2267-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2267-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2267-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2267-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2268" : helpers.makeTestYear("Pacific/Norfolk", [
		["2268-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2268-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2268-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2268-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2269" : helpers.makeTestYear("Pacific/Norfolk", [
		["2269-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2269-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2269-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2269-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2270" : helpers.makeTestYear("Pacific/Norfolk", [
		["2270-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2270-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2270-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2270-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2271" : helpers.makeTestYear("Pacific/Norfolk", [
		["2271-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2271-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2271-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2271-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2272" : helpers.makeTestYear("Pacific/Norfolk", [
		["2272-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2272-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2272-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2272-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2273" : helpers.makeTestYear("Pacific/Norfolk", [
		["2273-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2273-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2273-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2273-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2274" : helpers.makeTestYear("Pacific/Norfolk", [
		["2274-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2274-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2274-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2274-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2275" : helpers.makeTestYear("Pacific/Norfolk", [
		["2275-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2275-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2275-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2275-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2276" : helpers.makeTestYear("Pacific/Norfolk", [
		["2276-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2276-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2276-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2276-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2277" : helpers.makeTestYear("Pacific/Norfolk", [
		["2277-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2277-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2277-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2277-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2278" : helpers.makeTestYear("Pacific/Norfolk", [
		["2278-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2278-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2278-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2278-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2279" : helpers.makeTestYear("Pacific/Norfolk", [
		["2279-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2279-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2279-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2279-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2280" : helpers.makeTestYear("Pacific/Norfolk", [
		["2280-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2280-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2280-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2280-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2281" : helpers.makeTestYear("Pacific/Norfolk", [
		["2281-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2281-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2281-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2281-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2282" : helpers.makeTestYear("Pacific/Norfolk", [
		["2282-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2282-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2282-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2282-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2283" : helpers.makeTestYear("Pacific/Norfolk", [
		["2283-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2283-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2283-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2283-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2284" : helpers.makeTestYear("Pacific/Norfolk", [
		["2284-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2284-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2284-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2284-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2285" : helpers.makeTestYear("Pacific/Norfolk", [
		["2285-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2285-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2285-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2285-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2286" : helpers.makeTestYear("Pacific/Norfolk", [
		["2286-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2286-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2286-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2286-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2287" : helpers.makeTestYear("Pacific/Norfolk", [
		["2287-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2287-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2287-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2287-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2288" : helpers.makeTestYear("Pacific/Norfolk", [
		["2288-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2288-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2288-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2288-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2289" : helpers.makeTestYear("Pacific/Norfolk", [
		["2289-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2289-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2289-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2289-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2290" : helpers.makeTestYear("Pacific/Norfolk", [
		["2290-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2290-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2290-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2290-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2291" : helpers.makeTestYear("Pacific/Norfolk", [
		["2291-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2291-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2291-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2291-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2292" : helpers.makeTestYear("Pacific/Norfolk", [
		["2292-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2292-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2292-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2292-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2293" : helpers.makeTestYear("Pacific/Norfolk", [
		["2293-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2293-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2293-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2293-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2294" : helpers.makeTestYear("Pacific/Norfolk", [
		["2294-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2294-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2294-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2294-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2295" : helpers.makeTestYear("Pacific/Norfolk", [
		["2295-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2295-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2295-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2295-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2296" : helpers.makeTestYear("Pacific/Norfolk", [
		["2296-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2296-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2296-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2296-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2297" : helpers.makeTestYear("Pacific/Norfolk", [
		["2297-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2297-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2297-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2297-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2298" : helpers.makeTestYear("Pacific/Norfolk", [
		["2298-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2298-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2298-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2298-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2299" : helpers.makeTestYear("Pacific/Norfolk", [
		["2299-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2299-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2299-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2299-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2300" : helpers.makeTestYear("Pacific/Norfolk", [
		["2300-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2300-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2300-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2300-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2301" : helpers.makeTestYear("Pacific/Norfolk", [
		["2301-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2301-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2301-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2301-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2302" : helpers.makeTestYear("Pacific/Norfolk", [
		["2302-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2302-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2302-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2302-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2303" : helpers.makeTestYear("Pacific/Norfolk", [
		["2303-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2303-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2303-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2303-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2304" : helpers.makeTestYear("Pacific/Norfolk", [
		["2304-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2304-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2304-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2304-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2305" : helpers.makeTestYear("Pacific/Norfolk", [
		["2305-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2305-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2305-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2305-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2306" : helpers.makeTestYear("Pacific/Norfolk", [
		["2306-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2306-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2306-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2306-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2307" : helpers.makeTestYear("Pacific/Norfolk", [
		["2307-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2307-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2307-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2307-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2308" : helpers.makeTestYear("Pacific/Norfolk", [
		["2308-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2308-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2308-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2308-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2309" : helpers.makeTestYear("Pacific/Norfolk", [
		["2309-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2309-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2309-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2309-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2310" : helpers.makeTestYear("Pacific/Norfolk", [
		["2310-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2310-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2310-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2310-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2311" : helpers.makeTestYear("Pacific/Norfolk", [
		["2311-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2311-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2311-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2311-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2312" : helpers.makeTestYear("Pacific/Norfolk", [
		["2312-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2312-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2312-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2312-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2313" : helpers.makeTestYear("Pacific/Norfolk", [
		["2313-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2313-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2313-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2313-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2314" : helpers.makeTestYear("Pacific/Norfolk", [
		["2314-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2314-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2314-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2314-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2315" : helpers.makeTestYear("Pacific/Norfolk", [
		["2315-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2315-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2315-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2315-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2316" : helpers.makeTestYear("Pacific/Norfolk", [
		["2316-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2316-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2316-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2316-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2317" : helpers.makeTestYear("Pacific/Norfolk", [
		["2317-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2317-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2317-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2317-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2318" : helpers.makeTestYear("Pacific/Norfolk", [
		["2318-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2318-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2318-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2318-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2319" : helpers.makeTestYear("Pacific/Norfolk", [
		["2319-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2319-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2319-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2319-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2320" : helpers.makeTestYear("Pacific/Norfolk", [
		["2320-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2320-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2320-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2320-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2321" : helpers.makeTestYear("Pacific/Norfolk", [
		["2321-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2321-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2321-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2321-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2322" : helpers.makeTestYear("Pacific/Norfolk", [
		["2322-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2322-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2322-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2322-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2323" : helpers.makeTestYear("Pacific/Norfolk", [
		["2323-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2323-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2323-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2323-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2324" : helpers.makeTestYear("Pacific/Norfolk", [
		["2324-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2324-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2324-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2324-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2325" : helpers.makeTestYear("Pacific/Norfolk", [
		["2325-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2325-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2325-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2325-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2326" : helpers.makeTestYear("Pacific/Norfolk", [
		["2326-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2326-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2326-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2326-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2327" : helpers.makeTestYear("Pacific/Norfolk", [
		["2327-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2327-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2327-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2327-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2328" : helpers.makeTestYear("Pacific/Norfolk", [
		["2328-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2328-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2328-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2328-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2329" : helpers.makeTestYear("Pacific/Norfolk", [
		["2329-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2329-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2329-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2329-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2330" : helpers.makeTestYear("Pacific/Norfolk", [
		["2330-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2330-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2330-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2330-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2331" : helpers.makeTestYear("Pacific/Norfolk", [
		["2331-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2331-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2331-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2331-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2332" : helpers.makeTestYear("Pacific/Norfolk", [
		["2332-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2332-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2332-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2332-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2333" : helpers.makeTestYear("Pacific/Norfolk", [
		["2333-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2333-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2333-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2333-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2334" : helpers.makeTestYear("Pacific/Norfolk", [
		["2334-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2334-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2334-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2334-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2335" : helpers.makeTestYear("Pacific/Norfolk", [
		["2335-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2335-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2335-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2335-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2336" : helpers.makeTestYear("Pacific/Norfolk", [
		["2336-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2336-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2336-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2336-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2337" : helpers.makeTestYear("Pacific/Norfolk", [
		["2337-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2337-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2337-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2337-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2338" : helpers.makeTestYear("Pacific/Norfolk", [
		["2338-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2338-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2338-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2338-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2339" : helpers.makeTestYear("Pacific/Norfolk", [
		["2339-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2339-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2339-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2339-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2340" : helpers.makeTestYear("Pacific/Norfolk", [
		["2340-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2340-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2340-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2340-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2341" : helpers.makeTestYear("Pacific/Norfolk", [
		["2341-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2341-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2341-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2341-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2342" : helpers.makeTestYear("Pacific/Norfolk", [
		["2342-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2342-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2342-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2342-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2343" : helpers.makeTestYear("Pacific/Norfolk", [
		["2343-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2343-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2343-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2343-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2344" : helpers.makeTestYear("Pacific/Norfolk", [
		["2344-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2344-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2344-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2344-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2345" : helpers.makeTestYear("Pacific/Norfolk", [
		["2345-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2345-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2345-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2345-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2346" : helpers.makeTestYear("Pacific/Norfolk", [
		["2346-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2346-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2346-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2346-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2347" : helpers.makeTestYear("Pacific/Norfolk", [
		["2347-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2347-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2347-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2347-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2348" : helpers.makeTestYear("Pacific/Norfolk", [
		["2348-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2348-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2348-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2348-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2349" : helpers.makeTestYear("Pacific/Norfolk", [
		["2349-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2349-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2349-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2349-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2350" : helpers.makeTestYear("Pacific/Norfolk", [
		["2350-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2350-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2350-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2350-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2351" : helpers.makeTestYear("Pacific/Norfolk", [
		["2351-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2351-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2351-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2351-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2352" : helpers.makeTestYear("Pacific/Norfolk", [
		["2352-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2352-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2352-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2352-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2353" : helpers.makeTestYear("Pacific/Norfolk", [
		["2353-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2353-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2353-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2353-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2354" : helpers.makeTestYear("Pacific/Norfolk", [
		["2354-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2354-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2354-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2354-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2355" : helpers.makeTestYear("Pacific/Norfolk", [
		["2355-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2355-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2355-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2355-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2356" : helpers.makeTestYear("Pacific/Norfolk", [
		["2356-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2356-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2356-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2356-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2357" : helpers.makeTestYear("Pacific/Norfolk", [
		["2357-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2357-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2357-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2357-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2358" : helpers.makeTestYear("Pacific/Norfolk", [
		["2358-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2358-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2358-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2358-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2359" : helpers.makeTestYear("Pacific/Norfolk", [
		["2359-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2359-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2359-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2359-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2360" : helpers.makeTestYear("Pacific/Norfolk", [
		["2360-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2360-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2360-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2360-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2361" : helpers.makeTestYear("Pacific/Norfolk", [
		["2361-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2361-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2361-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2361-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2362" : helpers.makeTestYear("Pacific/Norfolk", [
		["2362-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2362-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2362-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2362-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2363" : helpers.makeTestYear("Pacific/Norfolk", [
		["2363-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2363-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2363-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2363-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2364" : helpers.makeTestYear("Pacific/Norfolk", [
		["2364-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2364-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2364-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2364-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2365" : helpers.makeTestYear("Pacific/Norfolk", [
		["2365-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2365-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2365-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2365-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2366" : helpers.makeTestYear("Pacific/Norfolk", [
		["2366-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2366-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2366-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2366-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2367" : helpers.makeTestYear("Pacific/Norfolk", [
		["2367-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2367-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2367-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2367-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2368" : helpers.makeTestYear("Pacific/Norfolk", [
		["2368-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2368-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2368-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2368-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2369" : helpers.makeTestYear("Pacific/Norfolk", [
		["2369-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2369-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2369-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2369-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2370" : helpers.makeTestYear("Pacific/Norfolk", [
		["2370-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2370-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2370-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2370-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2371" : helpers.makeTestYear("Pacific/Norfolk", [
		["2371-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2371-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2371-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2371-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2372" : helpers.makeTestYear("Pacific/Norfolk", [
		["2372-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2372-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2372-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2372-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2373" : helpers.makeTestYear("Pacific/Norfolk", [
		["2373-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2373-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2373-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2373-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2374" : helpers.makeTestYear("Pacific/Norfolk", [
		["2374-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2374-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2374-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2374-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2375" : helpers.makeTestYear("Pacific/Norfolk", [
		["2375-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2375-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2375-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2375-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2376" : helpers.makeTestYear("Pacific/Norfolk", [
		["2376-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2376-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2376-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2376-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2377" : helpers.makeTestYear("Pacific/Norfolk", [
		["2377-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2377-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2377-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2377-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2378" : helpers.makeTestYear("Pacific/Norfolk", [
		["2378-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2378-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2378-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2378-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2379" : helpers.makeTestYear("Pacific/Norfolk", [
		["2379-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2379-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2379-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2379-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2380" : helpers.makeTestYear("Pacific/Norfolk", [
		["2380-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2380-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2380-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2380-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2381" : helpers.makeTestYear("Pacific/Norfolk", [
		["2381-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2381-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2381-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2381-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2382" : helpers.makeTestYear("Pacific/Norfolk", [
		["2382-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2382-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2382-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2382-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2383" : helpers.makeTestYear("Pacific/Norfolk", [
		["2383-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2383-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2383-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2383-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2384" : helpers.makeTestYear("Pacific/Norfolk", [
		["2384-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2384-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2384-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2384-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2385" : helpers.makeTestYear("Pacific/Norfolk", [
		["2385-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2385-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2385-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2385-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2386" : helpers.makeTestYear("Pacific/Norfolk", [
		["2386-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2386-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2386-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2386-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2387" : helpers.makeTestYear("Pacific/Norfolk", [
		["2387-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2387-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2387-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2387-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2388" : helpers.makeTestYear("Pacific/Norfolk", [
		["2388-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2388-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2388-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2388-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2389" : helpers.makeTestYear("Pacific/Norfolk", [
		["2389-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2389-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2389-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2389-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2390" : helpers.makeTestYear("Pacific/Norfolk", [
		["2390-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2390-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2390-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2390-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2391" : helpers.makeTestYear("Pacific/Norfolk", [
		["2391-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2391-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2391-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2391-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2392" : helpers.makeTestYear("Pacific/Norfolk", [
		["2392-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2392-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2392-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2392-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2393" : helpers.makeTestYear("Pacific/Norfolk", [
		["2393-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2393-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2393-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2393-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2394" : helpers.makeTestYear("Pacific/Norfolk", [
		["2394-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2394-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2394-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2394-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2395" : helpers.makeTestYear("Pacific/Norfolk", [
		["2395-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2395-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2395-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2395-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2396" : helpers.makeTestYear("Pacific/Norfolk", [
		["2396-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2396-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2396-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2396-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2397" : helpers.makeTestYear("Pacific/Norfolk", [
		["2397-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2397-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2397-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2397-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2398" : helpers.makeTestYear("Pacific/Norfolk", [
		["2398-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2398-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2398-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2398-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2399" : helpers.makeTestYear("Pacific/Norfolk", [
		["2399-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2399-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2399-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2399-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2400" : helpers.makeTestYear("Pacific/Norfolk", [
		["2400-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2400-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2400-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2400-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2401" : helpers.makeTestYear("Pacific/Norfolk", [
		["2401-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2401-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2401-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2401-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2402" : helpers.makeTestYear("Pacific/Norfolk", [
		["2402-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2402-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2402-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2402-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2403" : helpers.makeTestYear("Pacific/Norfolk", [
		["2403-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2403-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2403-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2403-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2404" : helpers.makeTestYear("Pacific/Norfolk", [
		["2404-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2404-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2404-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2404-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2405" : helpers.makeTestYear("Pacific/Norfolk", [
		["2405-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2405-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2405-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2405-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2406" : helpers.makeTestYear("Pacific/Norfolk", [
		["2406-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2406-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2406-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2406-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2407" : helpers.makeTestYear("Pacific/Norfolk", [
		["2407-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2407-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2407-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2407-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2408" : helpers.makeTestYear("Pacific/Norfolk", [
		["2408-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2408-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2408-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2408-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2409" : helpers.makeTestYear("Pacific/Norfolk", [
		["2409-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2409-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2409-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2409-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2410" : helpers.makeTestYear("Pacific/Norfolk", [
		["2410-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2410-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2410-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2410-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2411" : helpers.makeTestYear("Pacific/Norfolk", [
		["2411-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2411-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2411-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2411-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2412" : helpers.makeTestYear("Pacific/Norfolk", [
		["2412-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2412-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2412-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2412-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2413" : helpers.makeTestYear("Pacific/Norfolk", [
		["2413-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2413-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2413-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2413-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2414" : helpers.makeTestYear("Pacific/Norfolk", [
		["2414-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2414-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2414-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2414-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2415" : helpers.makeTestYear("Pacific/Norfolk", [
		["2415-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2415-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2415-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2415-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2416" : helpers.makeTestYear("Pacific/Norfolk", [
		["2416-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2416-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2416-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2416-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2417" : helpers.makeTestYear("Pacific/Norfolk", [
		["2417-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2417-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2417-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2417-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2418" : helpers.makeTestYear("Pacific/Norfolk", [
		["2418-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2418-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2418-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2418-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2419" : helpers.makeTestYear("Pacific/Norfolk", [
		["2419-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2419-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2419-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2419-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2420" : helpers.makeTestYear("Pacific/Norfolk", [
		["2420-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2420-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2420-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2420-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2421" : helpers.makeTestYear("Pacific/Norfolk", [
		["2421-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2421-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2421-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2421-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2422" : helpers.makeTestYear("Pacific/Norfolk", [
		["2422-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2422-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2422-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2422-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2423" : helpers.makeTestYear("Pacific/Norfolk", [
		["2423-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2423-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2423-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2423-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2424" : helpers.makeTestYear("Pacific/Norfolk", [
		["2424-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2424-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2424-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2424-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2425" : helpers.makeTestYear("Pacific/Norfolk", [
		["2425-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2425-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2425-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2425-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2426" : helpers.makeTestYear("Pacific/Norfolk", [
		["2426-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2426-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2426-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2426-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2427" : helpers.makeTestYear("Pacific/Norfolk", [
		["2427-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2427-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2427-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2427-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2428" : helpers.makeTestYear("Pacific/Norfolk", [
		["2428-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2428-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2428-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2428-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2429" : helpers.makeTestYear("Pacific/Norfolk", [
		["2429-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2429-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2429-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2429-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2430" : helpers.makeTestYear("Pacific/Norfolk", [
		["2430-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2430-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2430-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2430-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2431" : helpers.makeTestYear("Pacific/Norfolk", [
		["2431-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2431-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2431-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2431-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2432" : helpers.makeTestYear("Pacific/Norfolk", [
		["2432-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2432-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2432-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2432-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2433" : helpers.makeTestYear("Pacific/Norfolk", [
		["2433-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2433-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2433-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2433-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2434" : helpers.makeTestYear("Pacific/Norfolk", [
		["2434-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2434-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2434-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2434-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2435" : helpers.makeTestYear("Pacific/Norfolk", [
		["2435-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2435-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2435-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2435-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2436" : helpers.makeTestYear("Pacific/Norfolk", [
		["2436-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2436-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2436-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2436-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2437" : helpers.makeTestYear("Pacific/Norfolk", [
		["2437-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2437-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2437-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2437-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2438" : helpers.makeTestYear("Pacific/Norfolk", [
		["2438-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2438-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2438-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2438-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2439" : helpers.makeTestYear("Pacific/Norfolk", [
		["2439-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2439-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2439-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2439-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2440" : helpers.makeTestYear("Pacific/Norfolk", [
		["2440-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2440-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2440-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2440-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2441" : helpers.makeTestYear("Pacific/Norfolk", [
		["2441-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2441-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2441-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2441-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2442" : helpers.makeTestYear("Pacific/Norfolk", [
		["2442-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2442-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2442-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2442-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2443" : helpers.makeTestYear("Pacific/Norfolk", [
		["2443-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2443-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2443-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2443-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2444" : helpers.makeTestYear("Pacific/Norfolk", [
		["2444-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2444-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2444-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2444-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2445" : helpers.makeTestYear("Pacific/Norfolk", [
		["2445-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2445-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2445-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2445-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2446" : helpers.makeTestYear("Pacific/Norfolk", [
		["2446-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2446-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2446-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2446-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2447" : helpers.makeTestYear("Pacific/Norfolk", [
		["2447-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2447-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2447-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2447-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2448" : helpers.makeTestYear("Pacific/Norfolk", [
		["2448-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2448-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2448-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2448-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2449" : helpers.makeTestYear("Pacific/Norfolk", [
		["2449-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2449-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2449-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2449-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2450" : helpers.makeTestYear("Pacific/Norfolk", [
		["2450-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2450-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2450-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2450-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2451" : helpers.makeTestYear("Pacific/Norfolk", [
		["2451-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2451-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2451-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2451-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2452" : helpers.makeTestYear("Pacific/Norfolk", [
		["2452-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2452-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2452-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2452-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2453" : helpers.makeTestYear("Pacific/Norfolk", [
		["2453-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2453-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2453-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2453-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2454" : helpers.makeTestYear("Pacific/Norfolk", [
		["2454-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2454-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2454-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2454-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2455" : helpers.makeTestYear("Pacific/Norfolk", [
		["2455-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2455-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2455-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2455-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2456" : helpers.makeTestYear("Pacific/Norfolk", [
		["2456-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2456-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2456-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2456-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2457" : helpers.makeTestYear("Pacific/Norfolk", [
		["2457-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2457-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2457-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2457-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2458" : helpers.makeTestYear("Pacific/Norfolk", [
		["2458-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2458-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2458-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2458-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2459" : helpers.makeTestYear("Pacific/Norfolk", [
		["2459-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2459-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2459-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2459-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2460" : helpers.makeTestYear("Pacific/Norfolk", [
		["2460-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2460-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2460-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2460-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2461" : helpers.makeTestYear("Pacific/Norfolk", [
		["2461-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2461-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2461-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2461-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2462" : helpers.makeTestYear("Pacific/Norfolk", [
		["2462-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2462-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2462-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2462-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2463" : helpers.makeTestYear("Pacific/Norfolk", [
		["2463-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2463-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2463-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2463-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2464" : helpers.makeTestYear("Pacific/Norfolk", [
		["2464-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2464-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2464-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2464-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2465" : helpers.makeTestYear("Pacific/Norfolk", [
		["2465-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2465-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2465-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2465-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2466" : helpers.makeTestYear("Pacific/Norfolk", [
		["2466-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2466-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2466-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2466-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2467" : helpers.makeTestYear("Pacific/Norfolk", [
		["2467-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2467-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2467-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2467-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2468" : helpers.makeTestYear("Pacific/Norfolk", [
		["2468-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2468-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2468-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2468-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2469" : helpers.makeTestYear("Pacific/Norfolk", [
		["2469-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2469-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2469-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2469-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2470" : helpers.makeTestYear("Pacific/Norfolk", [
		["2470-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2470-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2470-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2470-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2471" : helpers.makeTestYear("Pacific/Norfolk", [
		["2471-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2471-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2471-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2471-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2472" : helpers.makeTestYear("Pacific/Norfolk", [
		["2472-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2472-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2472-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2472-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2473" : helpers.makeTestYear("Pacific/Norfolk", [
		["2473-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2473-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2473-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2473-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2474" : helpers.makeTestYear("Pacific/Norfolk", [
		["2474-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2474-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2474-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2474-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2475" : helpers.makeTestYear("Pacific/Norfolk", [
		["2475-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2475-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2475-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2475-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2476" : helpers.makeTestYear("Pacific/Norfolk", [
		["2476-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2476-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2476-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2476-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2477" : helpers.makeTestYear("Pacific/Norfolk", [
		["2477-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2477-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2477-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2477-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2478" : helpers.makeTestYear("Pacific/Norfolk", [
		["2478-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2478-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2478-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2478-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2479" : helpers.makeTestYear("Pacific/Norfolk", [
		["2479-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2479-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2479-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2479-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2480" : helpers.makeTestYear("Pacific/Norfolk", [
		["2480-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2480-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2480-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2480-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2481" : helpers.makeTestYear("Pacific/Norfolk", [
		["2481-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2481-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2481-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2481-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2482" : helpers.makeTestYear("Pacific/Norfolk", [
		["2482-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2482-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2482-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2482-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2483" : helpers.makeTestYear("Pacific/Norfolk", [
		["2483-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2483-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2483-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2483-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2484" : helpers.makeTestYear("Pacific/Norfolk", [
		["2484-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2484-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2484-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2484-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2485" : helpers.makeTestYear("Pacific/Norfolk", [
		["2485-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2485-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2485-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2485-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2486" : helpers.makeTestYear("Pacific/Norfolk", [
		["2486-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2486-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2486-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2486-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2487" : helpers.makeTestYear("Pacific/Norfolk", [
		["2487-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2487-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2487-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2487-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2488" : helpers.makeTestYear("Pacific/Norfolk", [
		["2488-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2488-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2488-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2488-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2489" : helpers.makeTestYear("Pacific/Norfolk", [
		["2489-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2489-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2489-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2489-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2490" : helpers.makeTestYear("Pacific/Norfolk", [
		["2490-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2490-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2490-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2490-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2491" : helpers.makeTestYear("Pacific/Norfolk", [
		["2491-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2491-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2491-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2491-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2492" : helpers.makeTestYear("Pacific/Norfolk", [
		["2492-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2492-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2492-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2492-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2493" : helpers.makeTestYear("Pacific/Norfolk", [
		["2493-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2493-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2493-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2493-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2494" : helpers.makeTestYear("Pacific/Norfolk", [
		["2494-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2494-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2494-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2494-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2495" : helpers.makeTestYear("Pacific/Norfolk", [
		["2495-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2495-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2495-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2495-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2496" : helpers.makeTestYear("Pacific/Norfolk", [
		["2496-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2496-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2496-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2496-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2497" : helpers.makeTestYear("Pacific/Norfolk", [
		["2497-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2497-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2497-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2497-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2498" : helpers.makeTestYear("Pacific/Norfolk", [
		["2498-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2498-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2498-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2498-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2499" : helpers.makeTestYear("Pacific/Norfolk", [
		["2499-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2499-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2499-10-03T14:59:59+00:00", "01:59:59", "+11", -660]
	])
};