# Change Log
All notable changes to this project will be documented in this file, following the suggestions of [Keep a CHANGELOG](http://keepachangelog.com/). This project adheres to [Semantic Versioning](http://semver.org/).

## v1.0.8 - 2018-05-22
### Changed
- Bugfix: reduced encoder wasn't handling DOD as solvent
- Unit tests fix

## v1.0.7 - 2017-06-15
### Changed
- The decoder now treats null strings as nulls, instead of "". Roundtrips of null strings would fail because of that.

## v1.0.6 - 2017-06-14
### Changed
- Fixed issues with reduced encoder

## v1.0.5 - 2017-03-28
### Changed
- Removed unnecessary ParseException introduced in 1.0.4

## v1.0.4 - 2017-03-28
### Changed
- Faster MessagePack reading - replaced Jackson (probably slow because of reflection) with manual construction of objects, Jackson is still available, but the new solution is the default
- Faster parsing - moved computation from slow GenericDecoder.getNumBonds into constructor, which was invisible to profiler, but made parsing about 4x faster

## v1.0.3 - 2016-09-13
### Added
 - API functions to get the URL as a string and the data as an inputstream

## v1.0.2 - 2016-08-29
### Changed
 - Added inter group saccharide bonds to the reduced format
 - Cleanup of WriterUtils
 - Updated version string in MmtfStructure
 - Updated test data

## v1.0.1 - 2016-08-18
### Changed
 - Added saccharides to the reduced format

## v1.0.0 - 2016-08-15
### Changed
 - Updated to the URL to the v1.0 version

### Added
 - API function to get a byte array from the URL

## v0.2.2 - 2016-07-05
### Changed
 - Refactored the generation of Bioassemblies  
 - Refactored generateGroupMap to generateGroupList
 - Update to the serialization module - only construct object mapper once

### Added 
 - getBioassemblyName added to the API - return the BioassemblyName as a string.
 - Tests for EncoderUtils

## v0.2.1 - 2016-06-15
### Changed
 - Bugfix for the Reduced encoder. Chain name list and chain id list are now transferred correctly.
 - Update to the latest version of the dependencies
 - Added package info for the codec project
 - Improved docs and refactoring of test names

## v0.2.0 - 2016-06-03
### Added
- mmtf-codec module - consolidating mmtf-encoder and mmtf-decoder
- org.rcsb.mmtf.codec package - with enums for encoding and decoding generic data
- NCS Operator information
- R-work and release date information
- Number models, number chains and number groups in the MMTF data
- Reduced format encoder
- Enums to define the different encoding strategy
- common-lang dependency
- OptionParser class to parse type, length and parameter from 12 byte header

### Changed
- Codecs defined in 12 bytes at start of byte arrays. https://github.com/rcsb/mmtf/blob/master/spec.md#codecs
- Split lists are now recursive index encoded as single lists
- atomChargeList to formalChargeList
- xCoords -> xCoordList (and y,z and B-factors)

### Removed
- mmtf-encoder and mmtf-decoder modules

## v0.1.1 - 2016-06-02
### Changed
- Find max in empty int array now returns -1. Added a test to do so.
- Refactored some of the code to remove repitition
- Added private to several class level variables

### Added
- Added a new reduced encoder to produce the reduced format of the data.

## v0.1.0 - 2016-04-22
### Added
- Initial release










