#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>

#include "message.h"

#define BUFSIZE 128
#define PORT 4711

int main (int argc, char **argv) {

	errno=0;
	if (signal(SIGPIPE, SIG_IGN)==SIG_ERR) {
		fprintf(stderr, "signal(): could not set SIGPIPE signal\n");
		exit(1);
	}

	int listen_sock = socket(AF_INET, SOCK_STREAM, 0);
	if (listen_sock < 0) {
		perror("socket()");
		exit(1);
	}

	int val=1;
	setsockopt(listen_sock, SOL_SOCKET, SO_REUSEADDR, &val, sizeof(val));

	struct sockaddr_in addr;
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = htons(PORT);

	if ( bind(listen_sock, (struct sockaddr *)&addr, sizeof(addr)) ) {
		perror("bind()");
		exit(2);
	}
	
	if ( listen(listen_sock, 10)) {
		perror("listen()");
		exit(3);
	}
	

	while (1) {
		struct sockaddr_in peer;
		unsigned peerlen = sizeof(peer);
		int sock = accept(listen_sock, (struct sockaddr *) &peer, &peerlen);
		if (sock < 0) {
			perror("accept");
			exit(5);
		}
	
		if (fcntl(sock, F_SETFL, O_NONBLOCK) == -1) {
			perror("fcntl(NONBLOCK)");
			exit(6);
		}

		char name[INET_ADDRSTRLEN+1];
		inet_ntop(AF_INET, &peer.sin_addr, name, INET_ADDRSTRLEN);
		printf("connection to client %s established.\n", name);

		char buf[BUFSIZE];
		memset(buf, 0, BUFSIZE);
		const char *str = "you've been PWND!";
		memcpy(buf, str, strlen(str)+1);

		struct netmessage_buffer *sendbuf = NULL;
		if (netmessage_buffer_init(&sendbuf) != NETMSG_SUCCESS) {
			fprintf(stderr, "netmessage_buffer_init(): could not init buffer\n");
			exit(4);
		}

		unsigned long dropped=0;
		for (unsigned i=0; i<100000; i++) {
//			usleep(50000);
			int ret = sendmessage(sock, NETMSG_KICK, buf, BUFSIZE, sendbuf);
			if (ret==NETMSG_PARTIAL) {
				printf("partial write!\n");
//				usleep(5000);
				continue;
			}
			if (ret==NETMSG_FAIL_DELIVER) {
				dropped++;
				printf("dropped %d messages!\n", dropped);
				continue;
			}
			if (ret!=NETMSG_SUCCESS) {
				fprintf(stderr, "sendmessage(): error code %d\n", ret);
				break;
			}
		}
/*
		for (unsigned i=0; i<100000; i++) {
			int size = write(sock, buf, BUFSIZE);
			if (errno) {
				perror("write()");
				exit(5);
			}

			if (size < BUFSIZE) {
				fprintf(stderr, "write(): wrote %d instead of %d bytes!\n", size, BUFSIZE);
				exit(6);
			}

		}
*/

		if (close(sock)) {
			perror("close");
			exit(7);
		}
		printf("connection to client %s shutdown.\n", name);

		free(sendbuf);
	}


	return 0;
}
