(* file $Id$ *)

external raise : exn -> 'a = "%raise"

external not : bool -> bool = "%boolnot"

external (=) : 'a -> 'a -> bool = "%equal"
external (<>) : 'a -> 'a -> bool = "%notequal"
external (<) : 'a -> 'a -> bool = "%lessthan"
external (>) : 'a -> 'a -> bool = "%greaterthan"
external (<=) : 'a -> 'a -> bool = "%lessequal"
external (>=) : 'a -> 'a -> bool = "%greaterequal"

external (~-) : int -> int = "%negint"
external (+) : int -> int -> int = "%addint"
external (-) : int -> int -> int = "%subint"
external ( * ) : int -> int -> int = "%mulint"
external (/) : int -> int -> int = "%divint"
external (mod) : int -> int -> int = "%modint"

external (land) : int -> int -> int = "%andint"
external (lor) : int -> int -> int = "%orint"
external (lxor) : int -> int -> int = "%xorint"
external (lsl) : int -> int -> int = "%lslint"
external (lsr) : int -> int -> int = "%lsrint"
external (asr) : int -> int -> int = "%asrint"

external ignore : 'a -> unit = "%ignore"

type 'a ref = { mutable contents: 'a }
external ref : 'a -> 'a ref = "%makemutable"
external (!) : 'a ref -> 'a = "%field0"
external (:=) : 'a ref -> 'a -> unit = "%setfield0"
external incr : int ref -> unit = "%incr"
external decr : int ref -> unit = "%decr"

type 'a option = None | Some of 'a

type 'a weak_t;;
external weak_create: int -> 'a weak_t = "caml_weak_create";;
external weak_set : 'a weak_t -> int -> 'a option -> unit = "caml_weak_set";;
external weak_get: 'a weak_t -> int -> 'a option = "caml_weak_get";;

let x = 42;;

(* eof $Id$ *)
