/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvKeyProfile_H
#define MvKeyProfile_H

#include <iostream>
#include <map>
#include <vector>
#include <list>

using namespace std;

class MvKey
{
public:
	MvKey();
	MvKey(string n, string sn, string d=string("")) : name_(n), shortName_(sn),
	                                 description_(d), readIntAsString_(true), editable_(true) {};	
	MvKey(const MvKey&);
	
	MvKey* clone();	

	const string& shortName() const {return shortName_;}
	const string& name() const {return name_;}	
	const map<string,string>& metaData() const {return metaData_;}
	string metaData (const string&);
	const string& description() const {return description_;}

	void setShortName(string s) {shortName_=s;}
	void setName(string s) {name_=s;}
	void setMetaData(const string&,const string&);
	const map<string,string>& metaData() {return metaData_;}
	void setDescription(const string &d) {description_=d;}

	void addValue(string);
	const vector<string>& value() {return value_;}
	void  setValue(int,string);
	string firstValue();
	void clearMetaData();
	void clearData();

	map<string,int>& counter() {return counter_;}

	bool readIntAsString() const {return readIntAsString_;}
	void setReadIntAsString(bool b) {readIntAsString_=b;}
	bool editable() const {return editable_;}
	void setEditable(bool b) {editable_=b;}

protected:
	void addToCounter(string);

	string name_;
	string shortName_;
	string description_;
	map<string,string> metaData_;
	vector<string> value_;
	map<string,int> counter_;
	bool readIntAsString_;
	bool editable_; //if false only shortname is editable
};

class MvKeyProfile : public vector<MvKey*>
{
public:
	MvKeyProfile(string n) : name_(n), systemProfile_(false) {};
	MvKeyProfile(const MvKeyProfile&);
	~MvKeyProfile();	

	MvKeyProfile* clone();
	void clear();
	MvKey* addKey();
	void addKey(MvKey*);
	void deleteKey(int);
	void swap(int,int);
	void reposition(int,int);
	void reposition(vector<int>&);
	MvKey* key(string);
	string name() {return name_;};
	void setName(string n) {name_=n;};
	int valueNum(int);
	void clearKeyData();
	void setSystemProfile(bool b) {systemProfile_=b;}
	bool systemProfile() {return systemProfile_;}
	

private:
	string name_;
	bool systemProfile_;
	
};

#endif 
