/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <X11/Intrinsic.h>
#include <Metview.h>
#include <MvXApplication.h>


MvXApplication::MvXApplication(XtAppContext app, int argc,char **argv,
		const char *name, void* aparg, int nopts,option* opts): MvApplication(argc, argv, name, aparg, nopts, opts)
{
	Context = app;
	ListenToService(app, getService());
}

void MvXApplication::run(void)
{
	XtAppMainLoop(Context);
}

struct CbStuff {
	FILE     *file;
	inputproc proc;
	void*     data;

	CbStuff(FILE *f,inputproc p,void* d) : file(f),proc(p),data(d) {}
};

static void inputCb(XtPointer p,int *,XtInputId *id)
{
	CbStuff *s = (CbStuff*)p;	
	if(!s->proc(s->file,s->data))
	{
		delete s;
		XtRemoveInput(*id);
	}
}

void MvXApplication::addInputCallback(FILE*f,inputproc p,void *data)
{
     XtAppAddInput(Context,fileno(f),
			(XtPointer)XtInputReadMask,
			(XtInputCallbackProc)inputCb,
			(XtPointer)new CbStuff(f,p,data));
}

XtAppContext MvXApplication::context()
{
	MvXApplication& xapp = (MvXApplication&)instance();
	return xapp.Context;
}
