/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File SyncFolders.h
// Baudouin Raoult - ECMWF Oct 99

#ifndef SyncFolders_H
#define SyncFolders_H

#ifndef Timeout_H
#include "Timeout.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#include "UISyncFolders.h"

class SyncViewer;


class SyncFolders : public Timeout, public UISyncFolders_c {
public:

// -- Exceptions
	// None

// -- Contructors

	SyncFolders(Folder*,Folder*);

// -- Destructor

	~SyncFolders(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void make();
	void show();
	void hide();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static void add(Folder*,Folder*);
	static void sync(Folder*,Folder*);

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	SyncFolders(const SyncFolders&);
	SyncFolders& operator=(const SyncFolders&);

// -- Members

	FolderH user_;
	FolderH system_;

	SyncViewer* what_was_added_;
	SyncViewer* what_was_removed_;
	SyncViewer* changed_yours_;
	SyncViewer* changed_system_;

// -- Methods
	// None

	void adjust();

// -- Overridden methods

	// From Timeout

	virtual void run();

	// From XD

	virtual void closeCB(Widget, XtPointer);
	virtual void syncCB(Widget, XtPointer);
	virtual void entryCB(Widget, XtPointer);
	virtual void selectCB(Widget, XtPointer);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const SyncFolders& p)
	//	{ p.print(s); return s; }

};

inline void destroy(SyncFolders**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(SyncFolders);
//#endif

#endif
