/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ColorHelp_H
#include "ColorHelp.h"
#endif

#ifndef XMList_H
#include "XMList.h"
#endif

#ifndef HelpFactory_H
#include "HelpFactory.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef XPalette_H
#include "XPalette.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif


#include <Xm/Scale.h>
#include <Palette.h>


ColorHelp::ColorHelp(Widget parent, RequestPanel& owner, const Parameter& def):
	XHelp<UIColorHelp_c>(parent, owner, def),
	xlist_(list_,def)
{     
}

ColorHelp::~ColorHelp()
{
}

void ColorHelp::refresh(const vector<string>& values)
{
	xlist_.set(values);
}

long ColorHelp::flags()
{
	return EXPAND_FIRST_NAME;
}

void ColorHelp::set(Request& r) 
{
	r.set(param_.name(),xlist_.get());
}

void ColorHelp::browseCB(Widget,XtPointer)
{
	xlist_.changed();
	owner_.changed(*this);	
}

void ColorHelp::singleCB(Widget,XtPointer)
{
	xlist_.changed();
	owner_.changed(*this);	
}

void ColorHelp::multipleCB(Widget,XtPointer)
{
	xlist_.changed();
	owner_.changed(*this);	
}

void ColorHelp::extendedCB(Widget,XtPointer)
{
	xlist_.changed();
	owner_.changed(*this);	
}

void ColorHelp::rgbCB(Widget,XtPointer)
{
	int r = 0,g = 0,b = 0;

	XmScaleGetValue(red_,  &r);
	XmScaleGetValue(green_,&g);
	XmScaleGetValue(blue_, &b);


	char buf[1024];
	sprintf(buf,"RGB(%g,%g,%g)",r/100.0,g/100.0,b/100.0);

	XMText text(text_);
	text.set(buf);

	XtVaSetValues(sample_,
		XmNbackground,
		XPalette::magics(buf),
		0);
}

void ColorHelp::hslCB(Widget,XtPointer)
{
	int h = 0,s = 0,l = 0;

	XmScaleGetValue(hue_,  &h);
	XmScaleGetValue(saturation_,&s);
	XmScaleGetValue(lightness_, &l);

	char buf[1024];
	sprintf(buf,"HSL(%g,%g,%g)",h/1.0,s/100.0,l/100.0);

	XMText text(text_);
	text.set(buf);

	XtVaSetValues(sample_,
		XmNbackground,
		XPalette::magics(buf),
		0);
}

void ColorHelp::addCB(Widget,XtPointer)
{
	XMText text(text_);
	xlist_.add(text.get());

}

static HelpMaker<ColorHelp> maker1("colour");
static HelpMaker<ColorHelp> maker2("help_colour");
