/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Queue.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Queue_H
#define Queue_H

#include "inc_stl.h"


#ifndef TaskObserver_H
#include "TaskObserver.h"
#endif

#ifndef Task_H
#include "Task.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Runnable_H
#include "Runnable.h"
#endif


class Queue : public TaskObserver, public Runnable  {
public:

// -- Exceptions
	// None

// -- Contructors

	Queue(IconObject* owner);

// -- Destructor


// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void push(Task*);
	void ownerGone();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

	~Queue(); // Change to virtual if base class

// No copy allowed

	Queue(const Queue&);
	Queue& operator=(const Queue&);

// -- Members

	IconObjectH owner_;
	list<TaskH> tasks_;
	TaskH       active_;

// -- Methods

	void done();

// -- Overridden methods

	// From TaskObserver

	virtual void success(Task*,const Request&);
	virtual void failure(Task*);

	// From Runnable

	virtual void run();

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Queue& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Queue**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Queue);
//#endif

#endif
