/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Drop.h
// Baudouin Raoult - ECMWF Aug 99

#ifndef Drop_H
#define Drop_H

#include "inc_stl.h"
#include "IconObject.h"
#include "Request.h"
#include "TaskObserver.h"


class Drop : public TaskObserver {
public:

// -- Exceptions
	// None

// -- Contructors

	Drop(const set<IconObject*>&,const Request&,const string&,const Request&);

// -- Destructor

	virtual ~Drop(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void start();

// -- Overridden methods
	// None

// -- Class members
	MvRequest request() { return request_; }

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Drop(const Drop&);
	Drop& operator=(const Drop&);

// -- Members

	Request          request_;
	string           service_;
	Request          mode_;
	bool             error_;
	int              waiting_;

	map<IconObjectH,Request> requests_;
	map<Task*,IconObject*>   tasks_;

// -- Methods

	void check();

// -- Overridden methods

      virtual void success(Task*,const Request&);
      virtual void failure(Task*);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Drop& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Drop**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Drop);
//#endif

#endif
