#!/bin/sh
##
## Copyright (c) 2010-2019 Belledonne Communications SARL.
##
## This file is part of mediastreamer2.
##
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program. If not, see <http://www.gnu.org/licenses/>.
##

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

THEDIR=`pwd`
cd $srcdir

#AM_VERSION="1.10"
if ! type aclocal-$AM_VERSION 1>/dev/null 2>&1; then
	# automake-1.10 (recommended) is not available on Fedora 8
	AUTOMAKE=automake
	ACLOCAL=aclocal
else
	ACLOCAL=aclocal-${AM_VERSION}
	AUTOMAKE=automake-${AM_VERSION}
fi

INTLTOOLIZE=$(which intltoolize)

#workaround for mingw bug in intltoolize script.
if test "$INTLTOOLIZE" = "/bin/intltoolize" ; then
	INTLTOOLIZE=/usr/bin/intltoolize
fi

libtoolize="libtoolize"
for lt in glibtoolize libtoolize15 libtoolize14 libtoolize13 ; do
	if test -x /usr/bin/$lt ; then
		libtoolize=$lt ; break
	fi
	if test -x /usr/local/bin/$lt ; then
		libtoolize=$lt ; break
	fi
	if test -x /opt/local/bin/$lt ; then
		libtoolize=$lt ; break
	fi
done

if test -d /usr/local/share/aclocal ; then
	ACLOCAL_ARGS="$ACLOCAL_ARGS -I /usr/local/share/aclocal"
fi

if test -d /share/aclocal ; then
	ACLOCAL_ARGS="$ACLOCAL_ARGS -I /share/aclocal"
fi

echo "Generating build scripts in mediastreamer..."
set -x
$libtoolize --copy --force
$INTLTOOLIZE --copy --force --automake
$ACLOCAL -I m4 $ACLOCAL_ARGS
autoheader
$AUTOMAKE --force-missing --add-missing --copy
autoconf

#install git pre-commit hooks if possible
if [ -d .git/hooks ] && [ ! -f .git/hooks/pre-commit ]; then
	cp .git-pre-commit .git/hooks/pre-commit
	chmod +x .git/hooks/pre-commit
fi

cd $THEDIR
