# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.table_algorithm import TableAlgorithm


class TableFFT(TableAlgorithm):
    r"""
    TableFFT - FFT for table columns
    
    Superclass: TableAlgorithm
    
    TableFFT performs the Fast Fourier Transform on the columns of a
    table. It can perform the FFT per block : this performs something
    close to the Welch method but it uses raw FFTs instead of
    periodograms. This allows to reduce the impact of noise as well as
    speeding up the filter when the input signal is too big.
    
    It is also possible to apply a window on the input signal. If
    performing the FFT per block then the window will be applied to each
    block instead.
    
    The filter will look for a "Time" array (case insensitive) to
    determine the sampling frequency. "Time" array is considered to have
    the same frequency all along. If no "Time" array is found then the
    filter use the default frequency value.
    
    This filter will not apply the FFT on any arrays which names begin
    with 'vtk'.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTableFFT, obj, update, **traits)
    
    average_fft = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _average_fft_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAverageFft,
                        self.average_fft_)

    create_frequency_column = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _create_frequency_column_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCreateFrequencyColumn,
                        self.create_frequency_column_)

    normalize = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _normalize_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalize,
                        self.normalize_)

    optimize_for_real_input = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _optimize_for_real_input_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOptimizeForRealInput,
                        self.optimize_for_real_input_)

    block_size = traits.Int(1024, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _block_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBlockSize,
                        self.block_size)

    default_sample_rate = traits.Float(10000.0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _default_sample_rate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDefaultSampleRate,
                        self.default_sample_rate)

    number_of_block = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _number_of_block_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfBlock,
                        self.number_of_block)

    prefix_output_arrays = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _prefix_output_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPrefixOutputArrays,
                        self.prefix_output_arrays)

    windowing_function = traits.Int(4, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _windowing_function_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWindowingFunction,
                        self.windowing_function)

    _updateable_traits_ = \
    (('average_fft', 'GetAverageFft'), ('create_frequency_column',
    'GetCreateFrequencyColumn'), ('normalize', 'GetNormalize'),
    ('optimize_for_real_input', 'GetOptimizeForRealInput'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('block_size',
    'GetBlockSize'), ('default_sample_rate', 'GetDefaultSampleRate'),
    ('number_of_block', 'GetNumberOfBlock'), ('prefix_output_arrays',
    'GetPrefixOutputArrays'), ('windowing_function',
    'GetWindowingFunction'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'average_fft', 'create_frequency_column', 'debug',
    'global_warning_display', 'normalize', 'optimize_for_real_input',
    'release_data_flag', 'block_size', 'default_sample_rate',
    'number_of_block', 'object_name', 'prefix_output_arrays',
    'progress_text', 'windowing_function'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TableFFT, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TableFFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['average_fft', 'create_frequency_column', 'normalize',
            'optimize_for_real_input'], [], ['block_size', 'default_sample_rate',
            'number_of_block', 'object_name', 'prefix_output_arrays',
            'windowing_function']),
            title='Edit TableFFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TableFFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

