# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class QuaternionInterpolator(Object):
    r"""
    QuaternionInterpolator - interpolate a quaternion
    
    Superclass: Object
    
    This class is used to interpolate a series of quaternions
    representing the rotations of a 3D object.  The interpolation may be
    linear in form (using spherical linear interpolation SLERP), or via
    spline interpolation (using SQUAD). In either case the interpolation
    is specialized to quaternions since the interpolation occurs on the
    surface of the unit quaternion sphere.
    
    To use this class, specify at least two pairs of (t,q[4]) with the
    add_quaternion() method.  Next interpolate the tuples with the
    interpolate_quaternion(t,q[4]) method, where "t" must be in the range
    of (t_min,t_max) parameter values specified by the add_quaternion()
    method (t is clamped otherwise), and q[4] is filled in by the method.
    
    There are several important background references. Ken Shoemake
    described the practical application of quaternions for the
    interpolation of rotation (K. Shoemake, "Animating rotation with quaternion
    curves", Computer Graphics (Siggraph '85) 19(3):245--254, 1985).
    Another fine reference (available on-line) is E. B. Dam, M. Koch, and
    M. Lillholm, Technical Report DIKU-TR-98/5, Dept. of Computer
    Science, University of Copenhagen, Denmark.
    
    @warning
    Note that for two or less quaternions, Slerp (linear) interpolation
    is performed even if spline interpolation is requested. Also, the
    tangents to the first and last segments of spline interpolation are
    (arbitrarily) defined by repeating the first and last quaternions.
    
    @warning
    There are several methods particular to quaternions (norms, products,
    etc.) implemented interior to this class. These may be moved to a
    separate quaternion class at some point.
    
    @sa
    Quaternion
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkQuaternionInterpolator, obj, update, **traits)
    
    interpolation_type = tvtk_base.RevPrefixMap({'spline': 1, 'linear': 0}, default_value='spline', desc=\
        r"""
        Specify which type of function to use for interpolation. By
        default (set_interpolation_function_to_spline()), cubic spline
        interpolation using a modified Kochanek basis is employed.
        Otherwise, if set_interpolation_function_to_linear() is invoked,
        linear spherical interpolation is used between each pair of
        quaternions.
        """
    )

    def _interpolation_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolationType,
                        self.interpolation_type_)

    search_method = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _search_method_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSearchMethod,
                        self.search_method)

    def _get_maximum_t(self):
        return self._vtk_obj.GetMaximumT()
    maximum_t = traits.Property(_get_maximum_t, desc=\
        r"""
        
        """
    )

    def _get_minimum_t(self):
        return self._vtk_obj.GetMinimumT()
    minimum_t = traits.Property(_get_minimum_t, desc=\
        r"""
        Obtain some information about the interpolation range. The
        numbers returned (corresponding to parameter t, usually thought
        of as time) are undefined if the list of transforms is empty.
        This is a convenience method for interpolation.
        """
    )

    def _get_number_of_quaternions(self):
        return self._vtk_obj.GetNumberOfQuaternions()
    number_of_quaternions = traits.Property(_get_number_of_quaternions, desc=\
        r"""
        Return the number of quaternions in the list of quaternions to be
        interpolated.
        """
    )

    def add_quaternion(self, *args):
        """
        add_quaternion(self, t:float, q:Quaterniond) -> None
        C++: void add_quaternion(double t, const Quaterniond &q)
        add_quaternion(self, t:float, q:[float, float, float, float])
            -> None
        C++: void add_quaternion(double t, double q[4])
        Add another quaternion to the list of quaternions to be
        interpolated. Note that using the same time t value more than
        once replaces the previous quaternion at t. At least one
        quaternions must be added to define an interpolation functions.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddQuaternion, *my_args)
        return ret

    def initialize(self):
        """
        initialize(self) -> None
        C++: void initialize()
        Reset the class so that it contains no data; i.e., the array of
        (t,q[4]) information is discarded.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def interpolate_quaternion(self, *args):
        """
        interpolate_quaternion(self, t:float, q:Quaterniond) -> None
        C++: void interpolate_quaternion(double t, Quaterniond &q)
        interpolate_quaternion(self, t:float, q:[float, float, float,
            float]) -> None
        C++: void interpolate_quaternion(double t, double q[4])
        Interpolate the list of quaternions and determine a new
        quaternion (i.e., fill in the quaternion provided). If t is
        outside the range of (min,max) values, then t is clamped to lie
        within the range.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InterpolateQuaternion, *my_args)
        return ret

    def remove_quaternion(self, *args):
        """
        remove_quaternion(self, t:float) -> None
        C++: void remove_quaternion(double t)
        Delete the quaternion at a particular parameter t. If there is no
        quaternion tuple defined at t, then the method does nothing.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveQuaternion, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('interpolation_type',
    'GetInterpolationType'), ('search_method', 'GetSearchMethod'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'interpolation_type',
    'object_name', 'search_method'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(QuaternionInterpolator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit QuaternionInterpolator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['interpolation_type'], ['object_name', 'search_method']),
            title='Edit QuaternionInterpolator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit QuaternionInterpolator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

