# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class HyperTreeCursor(Object):
    r"""
    HyperTreeCursor - Objects for depth-first traversal hyper_trees.
    
    Superclass: Object
    
    Objects that can perform depth-first traversal of hyper_trees. This is
    an abstract class. Cursors are created by the hyper_tree
    implementation.
    
    @sa
    Object HyperTree HyperTreeGrid
    
    @par Thanks: This class was written by Philippe Pebay, Joachim
    Pouderoux, and Charles Law, Kitware 2013 This class was modified by
    Guenole Harel and Jacques-Bernard Lekien 2014 This class was revised
    by Philippe Pebay, 2016 This work was supported by Commissariat a
    l'Energie Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeCursor, obj, update, **traits)
    
    def _get_tree(self):
        return wrap_vtk(self._vtk_obj.GetTree())
    def _set_tree(self, arg):
        old_val = self._get_tree()
        self._wrap_call(self._vtk_obj.SetTree,
                        deref_vtk(arg))
        self.trait_property_changed('tree', old_val, arg)
    tree = traits.Property(_get_tree, _set_tree, desc=\
        r"""
        Return the hyper_tree to which the cursor is pointing.
        """
    )

    def _get_child_index(self):
        return self._vtk_obj.GetChildIndex()
    child_index = traits.Property(_get_child_index, desc=\
        r"""
        Return the child number of the current vertex relative to its
        parent.
        \pre not_root: !is_root().
        \post valid_range: result>=0 && result<get_number_of_children()
        """
    )

    def _get_dimension(self):
        return self._vtk_obj.GetDimension()
    dimension = traits.Property(_get_dimension, desc=\
        r"""
        Return the dimension of the tree.
        \post positive_result: result>0
        """
    )

    def _get_level(self):
        return self._vtk_obj.GetLevel()
    level = traits.Property(_get_level, desc=\
        r"""
        Return the level of the vertex pointed by the cursor.
        \post positive_result: result>=0
        """
    )

    def _get_number_of_children(self):
        return self._vtk_obj.GetNumberOfChildren()
    number_of_children = traits.Property(_get_number_of_children, desc=\
        r"""
        Return the number of children for each node (non-vertex leaf) of
        the tree.
        \post positive_number: result>0
        """
    )

    def _get_vertex_id(self):
        return self._vtk_obj.GetVertexId()
    vertex_id = traits.Property(_get_vertex_id, desc=\
        r"""
        Return the index of the current vertex in the tree.
        """
    )

    def clone(self):
        """
        clone(self) -> HyperTreeCursor
        C++: virtual HyperTreeCursor *clone()
        Create a copy of `this'.
        \\post results_exists:result!=0
        \\post same_tree: result->same_tree(this)
        """
        ret = wrap_vtk(self._vtk_obj.Clone())
        return ret
        

    def is_equal(self, *args):
        """
        is_equal(self, other:HyperTreeCursor) -> bool
        C++: virtual bool is_equal(HyperTreeCursor *other)
        Is `this' equal to `other'?
        \\pre other_exists: other!=0
        \\pre same_hypertree: this->same_tree(other);
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsEqual, *my_args)
        return ret

    def is_leaf(self):
        """
        is_leaf(self) -> bool
        C++: virtual bool is_leaf()
        Is the cursor pointing to a leaf?
        """
        ret = self._vtk_obj.IsLeaf()
        return ret
        

    def is_root(self):
        """
        is_root(self) -> bool
        C++: virtual bool is_root()
        Is the cursor at tree root?
        """
        ret = self._vtk_obj.IsRoot()
        return ret
        

    def same_tree(self, *args):
        """
        same_tree(self, other:HyperTreeCursor) -> int
        C++: virtual int same_tree(HyperTreeCursor *other)
        Are `this' and `other' pointing on the same hypertree?
        \\pre other_exists: other!=0
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SameTree, *my_args)
        return ret

    def to_child(self, *args):
        """
        to_child(self, child:int) -> None
        C++: virtual void to_child(int child)
        Move the cursor to child `child' of the current vertex.
        \\pre not_leaf: !is_leaf()
        \\pre valid_child: child>=0 && child<this->get_number_of_children()
        """
        ret = self._wrap_call(self._vtk_obj.ToChild, *args)
        return ret

    def to_parent(self):
        """
        to_parent(self) -> None
        C++: virtual void to_parent()
        Move the cursor to the parent of the current vertex.
        \\pre not_root: !is_root()
        """
        ret = self._vtk_obj.ToParent()
        return ret
        

    def to_root(self):
        """
        to_root(self) -> None
        C++: virtual void to_root()
        Move the cursor to the root vertex.
        \\pre can be root
        \\post is_root: is_root()
        """
        ret = self._vtk_obj.ToRoot()
        return ret
        

    def to_same_vertex(self, *args):
        """
        to_same_vertex(self, other:HyperTreeCursor) -> None
        C++: virtual void to_same_vertex(HyperTreeCursor *other)
        Move the cursor to the same vertex pointed by `other'.
        \\pre other_exists: other!=0
        \\pre same_hypertree: this->same_tree(other);
        \\post equal: this->is_equal(other)
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ToSameVertex, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeCursor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit HyperTreeCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

