# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class DiscreteFlyingEdgesClipper2D(PolyDataAlgorithm):
    r"""
    DiscreteFlyingEdgesClipper2D - generate filled regions from
    segmented 2D image data
    
    Superclass: PolyDataAlgorithm
    
    DiscreteFlyingEdgesClipper2D creates filled polygons from a label
    map (e.g., segmented image) using a variation of the flying edges
    algorithm adapted for 2D clipping. The input is a 2D image where each
    pixel is labeled (integer labels are preferred to real values), and
    the output data is polygonal data representing labeled regions. (Note
    that on output each region [corresponding to a different contour
    value] may share points on a shared boundary.)
    
    While this filter is similar to a contouring operation, label maps do
    not provide continuous function values meaning that usual
    interpolation along edges is not possible. Instead, when the edge
    endpoints are labeled in differing regions, the edge is split at its
    midpoint. In addition, besides producing intersection points at the
    mid-point of edges, the filter may also generate points interior to
    the pixel cells. For example, if the four vertices of a pixel cell
    are labeled with different regions, then an interior point is created
    and four rectangular "regions" are produced.
    
    Note that one nice feature of this filter is that algorithm execution
    occurs only one time no matter the number of contour values. In many
    contouring-like algorithms, each separate contour value requires an
    additional algorithm execution with a new contour value. So in this
    filter large numbers of contour values do not significantly affect
    overall speed.
    
    @warning This filter is specialized to 2D images.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    SurfaceNets2D DiscreteFlyingEdges2D DiscreteMarchingCubes
    ContourLoopExtraction FlyingEdges2D FlyingEdges3D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDiscreteFlyingEdgesClipper2D, obj, update, **traits)
    
    compute_scalars = tvtk_base.true_bool_trait(desc=\
        r"""
        Option to set the cell scalars of the output. The scalars will be
        the contour values. By default this flag is on.
        """
    )

    def _compute_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeScalars,
                        self.compute_scalars_)

    array_component = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get which component of a multi-component scalar array to
        contour on; defaults to 0.
        """
    )

    def _array_component_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayComponent,
                        self.array_component)

    number_of_contours = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set the number of contours to place into the list. You only
        really need to use this method to reduce list size. The method
        set_value() will automatically increase list size as needed.
        """
    )

    def _number_of_contours_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfContours,
                        self.number_of_contours)

    def get_value(self, *args):
        """
        get_value(self, i:int) -> float
        C++: double get_value(int i)
        Get the ith contour value.
        """
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, i:int, value:float) -> None
        C++: void set_value(int i, double value)
        Set a particular contour value at contour number i. The index i
        ranges between 0 <= i <number_of_contours. (Note: while contour
        values are expressed as doubles, the underlying scalar data may
        be a different type. During execution the contour values are
        static cast to the type of the scalar values.)
        """
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_values(self):
        return self._vtk_obj.GetValues()
    values = traits.Property(_get_values, desc=\
        r"""
        Get a pointer to an array of contour values. There will be
        get_number_of_contours() values in the list.
        """
    )

    def get_values(self, *args):
        """
        get_values(self) -> Pointer
        C++: double *get_values()
        get_values(self, contourValues:[float, ...]) -> None
        C++: void get_values(double *contourValues)
        Get a pointer to an array of contour values. There will be
        get_number_of_contours() values in the list.
        """
        ret = self._wrap_call(self._vtk_obj.GetValues, *args)
        return ret

    def generate_values(self, *args):
        """
        generate_values(self, numContours:int, range:[float, float])
            -> None
        C++: void generate_values(int numContours, double range[2])
        generate_values(self, numContours:int, rangeStart:float,
            rangeEnd:float) -> None
        C++: void generate_values(int numContours, double rangeStart,
            double rangeEnd)
        Generate numContours equally spaced contour values between the
        specified range. Contour values will include min/max range
        values.
        """
        ret = self._wrap_call(self._vtk_obj.GenerateValues, *args)
        return ret

    _updateable_traits_ = \
    (('compute_scalars', 'GetComputeScalars'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('array_component', 'GetArrayComponent'),
    ('number_of_contours', 'GetNumberOfContours'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_scalars', 'debug',
    'global_warning_display', 'release_data_flag', 'array_component',
    'number_of_contours', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DiscreteFlyingEdgesClipper2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DiscreteFlyingEdgesClipper2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_scalars'], [], ['array_component',
            'number_of_contours', 'object_name']),
            title='Edit DiscreteFlyingEdgesClipper2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DiscreteFlyingEdgesClipper2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

