package org.apache.maven.enforcer.rule.api;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import javax.annotation.Nonnull;

/**
 * Interface to be implemented by any rules as of version 2.0 executed by the enforcer.
 *
 * @author Mirko Friedenhagen
 * @version $Id: EnforcerRule2.java 1663790 2015-03-03 21:07:38Z khmarbaise $
 * @since 1.4
 */
public interface EnforcerRule2 extends EnforcerRule
{
    /**
     * Returns the level of enforcement.
     *
     * @return level
     */
    @Nonnull
    EnforcerLevel getLevel();

}
