// Tags: not-a-test
// Copyright (c) Object Oriented Concepts, Inc. Billerica, MA, USA

// Adapted for Mauve by Audrius Meskauskas <audriusa@bluewin.ch>

// This file is part of Mauve.

// Mauve is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// Mauve is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with Mauve; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

/*
This code originally came from the OMG's CORBA Open Source Testing project,
which lived at cost.omg.org. That site no longer exists.

All the contributing companies agreed to release their tests under the
terms of the GNU Lesser General Public License, available in the file
COPYING.LIB.

The code has been modified integrating into Mauve test environment and
removing tests that are not yet supported by Suns jre 1.4. Hence the license
is now GPL.

We downloaded the code from http://sourceforge.net/projects/corba-cost/,
administrated by Duncan Grisby.
*/

package gnu.testlet.org.omg.PortableServer.POA;

public abstract class TestHelper
{
  private static String _id = "IDL:test/poa/Test:1.0";

  public static synchronized org.omg.CORBA.TypeCode type()
  {
    return org.omg.CORBA.ORB.init().create_interface_tc(TestHelper.id(), "Test");
  }

  public static String id()
  {
    return _id;
  }

  public static Test narrow(org.omg.CORBA.Object obj)
  {
    if (obj == null)
      return null;
    else if (obj instanceof Test)
      return (Test) obj;
    else if (!obj._is_a(id()))
      throw new org.omg.CORBA.BAD_PARAM();
    else
      {
        org.omg.CORBA.portable.Delegate delegate =
          ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate();
        _TestStub stub = new _TestStub();
        stub._set_delegate(delegate);
        return stub;
      }
  }
}
