/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.DataSource;
import org.mariadb.jdbc.MariaDbDataSource;
import wrappers.JdbcInterface;

public class MariadbInterface
extends JdbcInterface {
    public MariadbInterface() {
        this(true);
    }

    public MariadbInterface(boolean b) {
        super(b);
        if (dst == null) {
            dst = new Hashtable();
        }
    }

    @Override
    public int JdbcConnect(String[] parms, int fsize, boolean scrollable) {
        int rc = 0;
        String url = parms[1];
        DataSource ds = null;
        MariaDbDataSource ads = null;
        if (this.DEBUG) {
            System.out.println("Connecting to MariaDB data source");
        }
        try {
            this.CheckURL(url, "mariadb");
            ds = (DataSource)dst.get(url);
            if (ds == null) {
                ads = new MariaDbDataSource();
                ads.setUrl(url);
                if (parms[2] != null) {
                    ads.setUser(parms[2]);
                }
                if (parms[3] != null) {
                    ads.setPassword(parms[3]);
                }
                ds = ads;
                dst.put(url, ds);
            }
            this.conn = ds.getConnection();
            this.dbmd = this.conn.getMetaData();
            this.stmt = this.GetStmt(fsize, scrollable);
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            rc = -2;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            rc = -3;
        }
        return rc;
    }
}

