/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-authenticated-mailbox.h"

#include "mn-authenticated-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 29 "src/mn-authenticated-mailbox.gob"

#include <glib/gi18n.h>
#include <gnome.h>
#include "mn-mailbox-private.h"
#include "mn-shell.h"
#include "mn-util.h"
#include "mn-keyring.h"

#line 35 "mn-authenticated-mailbox.c"
/* self casting macros */
#define SELF(x) MN_AUTHENTICATED_MAILBOX(x)
#define SELF_CONST(x) MN_AUTHENTICATED_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_AUTHENTICATED_MAILBOX(x)
#define TYPE_SELF MN_TYPE_AUTHENTICATED_MAILBOX
#define SELF_CLASS(x) MN_AUTHENTICATED_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_AUTHENTICATED_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNAuthenticatedMailbox Self;
typedef MNAuthenticatedMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_init (MNAuthenticatedMailbox * o);
#line 54 "mn-authenticated-mailbox.c"
#line 87 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_class_init (MNAuthenticatedMailboxClass * class);
#line 57 "mn-authenticated-mailbox.c"
#line 97 "src/mn-authenticated-mailbox.gob"
static void ___3_mn_authenticated_mailbox_seal (MNMailbox * mailbox);
#line 60 "mn-authenticated-mailbox.c"
#line 110 "src/mn-authenticated-mailbox.gob"
static void ___4_mn_authenticated_mailbox_added (MNMailbox * mailbox);
#line 63 "mn-authenticated-mailbox.c"
#line 130 "src/mn-authenticated-mailbox.gob"
static void ___5_mn_authenticated_mailbox_removed (MNMailbox * mailbox);
#line 66 "mn-authenticated-mailbox.c"
#line 152 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_set_password (MNAuthenticatedMailbox * self);
#line 69 "mn-authenticated-mailbox.c"
#line 174 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_set_password_cb (GnomeKeyringResult result, guint32 item_id, gpointer data);
#line 72 "mn-authenticated-mailbox.c"
#line 200 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_set_set_password_request (MNAuthenticatedMailbox * self, gpointer request);
#line 75 "mn-authenticated-mailbox.c"
#line 207 "src/mn-authenticated-mailbox.gob"
static void ___9_mn_authenticated_mailbox_check (MNMailbox * mailbox);
#line 78 "mn-authenticated-mailbox.c"
#line 224 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_check_thread_cb (MNAuthenticatedMailbox * self);
#line 81 "mn-authenticated-mailbox.c"
static void ___real_mn_authenticated_mailbox_authenticated_check (MNAuthenticatedMailbox * self);
#line 238 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_authenticated_check (MNAuthenticatedMailbox * self);
#line 85 "mn-authenticated-mailbox.c"
#line 320 "src/mn-authenticated-mailbox.gob"
static char * mn_authenticated_mailbox_get_password_sync (MNAuthenticatedMailbox * self);
#line 88 "mn-authenticated-mailbox.c"
#line 333 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_get_password_sync_request_cb (gpointer request, gpointer data);
#line 91 "mn-authenticated-mailbox.c"
#line 365 "src/mn-authenticated-mailbox.gob"
static gboolean mn_authenticated_mailbox_prompt_for_password (MNAuthenticatedMailbox * self, char ** password, const char * format, ...) G_GNUC_PRINTF(3, 4);
#line 94 "mn-authenticated-mailbox.c"
#line 414 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_set_prompted_password (MNAuthenticatedMailbox * self, const char * keyring, const char * password);
#line 97 "mn-authenticated-mailbox.c"
#line 445 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_set_prompted_password_request_cb (gpointer request, gpointer data);
#line 100 "mn-authenticated-mailbox.c"
#line 458 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_handle_set_password_result (MNAuthenticatedMailbox * self, GnomeKeyringResult result);
#line 103 "mn-authenticated-mailbox.c"
#line 487 "src/mn-authenticated-mailbox.gob"
static void mn_authenticated_mailbox_delete_password (MNAuthenticatedMailbox * self, const char * keyring, guint32 item_id);
#line 106 "mn-authenticated-mailbox.c"

enum {
	PROP_0,
	PROP_USERNAME,
	PROP_PASSWORD,
	PROP_SETTING_PASSWORD
};

/* pointer to the class of our parent */
static MNMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_get_setting_password mn_authenticated_mailbox_get_setting_password
#define self_set_password mn_authenticated_mailbox_set_password
#define self_set_password_cb mn_authenticated_mailbox_set_password_cb
#define self_set_set_password_request mn_authenticated_mailbox_set_set_password_request
#define self_check_thread_cb mn_authenticated_mailbox_check_thread_cb
#define self_authenticated_check mn_authenticated_mailbox_authenticated_check
#define self_parse_username mn_authenticated_mailbox_parse_username
#define self_fill_password mn_authenticated_mailbox_fill_password
#define self_get_password_sync mn_authenticated_mailbox_get_password_sync
#define self_get_password_sync_request_cb mn_authenticated_mailbox_get_password_sync_request_cb
#define self_auth_failed mn_authenticated_mailbox_auth_failed
#define self_prompt_for_password mn_authenticated_mailbox_prompt_for_password
#define self_set_prompted_password mn_authenticated_mailbox_set_prompted_password
#define self_set_prompted_password_request_cb mn_authenticated_mailbox_set_prompted_password_request_cb
#define self_handle_set_password_result mn_authenticated_mailbox_handle_set_password_result
#define self_get_password mn_authenticated_mailbox_get_password
#define self_delete_password mn_authenticated_mailbox_delete_password
GType
mn_authenticated_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNAuthenticatedMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_authenticated_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNAuthenticatedMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_authenticated_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_MAILBOX, "MNAuthenticatedMailbox", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNAuthenticatedMailbox *)g_object_new(mn_authenticated_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNAuthenticatedMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNAuthenticatedMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNAuthenticatedMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNAuthenticatedMailbox *)g_object_new_valist (mn_authenticated_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::finalize"
	MNAuthenticatedMailbox *self G_GNUC_UNUSED = MN_AUTHENTICATED_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 40 "src/mn-authenticated-mailbox.gob"
	if(self->username) { g_free ((gpointer) self->username); self->username = NULL; }
#line 189 "mn-authenticated-mailbox.c"
#line 56 "src/mn-authenticated-mailbox.gob"
	if(self->password) { g_free ((gpointer) self->password); self->password = NULL; }
#line 192 "mn-authenticated-mailbox.c"
#line 60 "src/mn-authenticated-mailbox.gob"
	if(self->keyring_username) { g_free ((gpointer) self->keyring_username); self->keyring_username = NULL; }
#line 195 "mn-authenticated-mailbox.c"
#line 61 "src/mn-authenticated-mailbox.gob"
	if(self->keyring_domain) { g_free ((gpointer) self->keyring_domain); self->keyring_domain = NULL; }
#line 198 "mn-authenticated-mailbox.c"
#line 62 "src/mn-authenticated-mailbox.gob"
	if(self->keyring_server) { g_free ((gpointer) self->keyring_server); self->keyring_server = NULL; }
#line 201 "mn-authenticated-mailbox.c"
#line 63 "src/mn-authenticated-mailbox.gob"
	if(self->keyring_protocol) { g_free ((gpointer) self->keyring_protocol); self->keyring_protocol = NULL; }
#line 204 "mn-authenticated-mailbox.c"
#line 64 "src/mn-authenticated-mailbox.gob"
	if(self->keyring_authtype) { g_free ((gpointer) self->keyring_authtype); self->keyring_authtype = NULL; }
#line 207 "mn-authenticated-mailbox.c"
#line 77 "src/mn-authenticated-mailbox.gob"
	if(self->runtime_password) { g_free ((gpointer) self->runtime_password); self->runtime_password = NULL; }
#line 210 "mn-authenticated-mailbox.c"
#line 84 "src/mn-authenticated-mailbox.gob"
	if(self->_priv->prompted_password_keyring) { g_free ((gpointer) self->_priv->prompted_password_keyring); self->_priv->prompted_password_keyring = NULL; }
#line 213 "mn-authenticated-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_authenticated_mailbox_init (MNAuthenticatedMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_AUTHENTICATED_MAILBOX,MNAuthenticatedMailboxPrivate);
}
#undef __GOB_FUNCTION__
#line 87 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_class_init (MNAuthenticatedMailboxClass * class G_GNUC_UNUSED)
{
#line 228 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNAuthenticatedMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_MAILBOX);

#line 97 "src/mn-authenticated-mailbox.gob"
	mn_mailbox_class->seal = ___3_mn_authenticated_mailbox_seal;
#line 110 "src/mn-authenticated-mailbox.gob"
	mn_mailbox_class->added = ___4_mn_authenticated_mailbox_added;
#line 130 "src/mn-authenticated-mailbox.gob"
	mn_mailbox_class->removed = ___5_mn_authenticated_mailbox_removed;
#line 207 "src/mn-authenticated-mailbox.gob"
	mn_mailbox_class->check = ___9_mn_authenticated_mailbox_check;
#line 238 "src/mn-authenticated-mailbox.gob"
	class->authenticated_check = ___real_mn_authenticated_mailbox_authenticated_check;
#line 247 "mn-authenticated-mailbox.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("username" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_REQUIRED | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_USERNAME,
		param_spec);
	param_spec = g_param_spec_string
		("password" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD));
	g_object_class_install_property (g_object_class,
		PROP_PASSWORD,
		param_spec);
	param_spec = g_param_spec_boolean
		("setting_password" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_SETTING_PASSWORD,
		param_spec);
    }
 {
#line 88 "src/mn-authenticated-mailbox.gob"

    /*
     * We might need to save the password to the keyring before the
     * first check, so we will call mn_mailbox_enable_checking()
     * ourselves.
     */
    MN_MAILBOX_CLASS(class)->enable_checking_when_added = FALSE;
  
#line 292 "mn-authenticated-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::set_property"
{
	MNAuthenticatedMailbox *self G_GNUC_UNUSED;

	self = MN_AUTHENTICATED_MAILBOX (object);

	switch (property_id) {
	case PROP_USERNAME:
		{
#line 41 "src/mn-authenticated-mailbox.gob"
{ char *old = self->username; self->username = g_value_dup_string (VAL); g_free (old); }
#line 313 "mn-authenticated-mailbox.c"
		}
		break;
	case PROP_PASSWORD:
		{
#line 57 "src/mn-authenticated-mailbox.gob"
{ char *old = self->password; self->password = g_value_dup_string (VAL); g_free (old); }
#line 320 "mn-authenticated-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::get_property"
{
	MNAuthenticatedMailbox *self G_GNUC_UNUSED;

	self = MN_AUTHENTICATED_MAILBOX (object);

	switch (property_id) {
	case PROP_USERNAME:
		{
#line 41 "src/mn-authenticated-mailbox.gob"
g_value_set_string (VAL, self->username);
#line 351 "mn-authenticated-mailbox.c"
		}
		break;
	case PROP_PASSWORD:
		{
#line 57 "src/mn-authenticated-mailbox.gob"
g_value_set_string (VAL, self->password);
#line 358 "mn-authenticated-mailbox.c"
		}
		break;
	case PROP_SETTING_PASSWORD:
		{
#line 71 "src/mn-authenticated-mailbox.gob"

      g_value_set_boolean(VAL, selfp->set_password_request != NULL);
    
#line 367 "mn-authenticated-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 71 "src/mn-authenticated-mailbox.gob"
gboolean 
mn_authenticated_mailbox_get_setting_password (MNAuthenticatedMailbox * self)
{
#line 387 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::get_setting_password"
{
#line 70 "src/mn-authenticated-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "setting_password", &val, NULL); return val;
}}
#line 393 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__


#line 97 "src/mn-authenticated-mailbox.gob"
static void 
___3_mn_authenticated_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 400 "mn-authenticated-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::seal"
{
#line 99 "src/mn-authenticated-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    if (self->password)
      mn_shell->mailboxes->must_save_after_load = TRUE;

    self_parse_username(self, &self->keyring_username, &self->keyring_domain);
  }}
#line 418 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 110 "src/mn-authenticated-mailbox.gob"
static void 
___4_mn_authenticated_mailbox_added (MNMailbox * mailbox G_GNUC_UNUSED)
#line 425 "mn-authenticated-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->added) \
		(* MN_MAILBOX_CLASS(parent_class)->added)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::added"
{
#line 112 "src/mn-authenticated-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    /*
     * If self->password is set, the password must be saved to the
     * keyring (either because the user has just added the mailbox or
     * because a mailboxes.xml produced by an older version of MN was
     * loaded). Checking will be enabled after the password has been
     * saved. Otherwise we must enable checking immediately.
     */
    if (self->password)
      self_set_password(self);
    else
      mn_mailbox_enable_checking(mailbox);
  }}
#line 450 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 130 "src/mn-authenticated-mailbox.gob"
static void 
___5_mn_authenticated_mailbox_removed (MNMailbox * mailbox G_GNUC_UNUSED)
#line 457 "mn-authenticated-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->removed) \
		(* MN_MAILBOX_CLASS(parent_class)->removed)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::removed"
{
#line 132 "src/mn-authenticated-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    if (selfp->auth_dialog)
      gtk_dialog_response(GTK_DIALOG(selfp->auth_dialog), GTK_RESPONSE_CANCEL);

    if (selfp->get_password_request)
      gnome_keyring_cancel_request(selfp->get_password_request);

    if (selfp->set_password_request)
      gnome_keyring_cancel_request(selfp->set_password_request);

    /*
     * We do not remove the password from the keyring, since it is
     * meant to be shared with other applications
     */
  }}
#line 484 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 152 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_set_password (MNAuthenticatedMailbox * self)
{
#line 492 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::set_password"
#line 152 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 152 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 498 "mn-authenticated-mailbox.c"
{
#line 154 "src/mn-authenticated-mailbox.gob"
	
    g_assert(self->password != NULL);
    g_assert(selfp->set_password_request == NULL);

    g_object_ref(self);
    self_set_set_password_request(self,
				  gnome_keyring_set_network_password(NULL,
								     self->keyring_username,
								     self->keyring_domain,
								     self->keyring_server,
								     NULL,
								     self->keyring_protocol,
								     self->keyring_authtype,
								     self->keyring_port,
								     self->password,
								     self_set_password_cb,
								     self,
								     g_object_unref));
  }}
#line 520 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 174 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_set_password_cb (GnomeKeyringResult result, guint32 item_id, gpointer data)
{
#line 527 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::set_password_cb"
{
#line 178 "src/mn-authenticated-mailbox.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();

    self_set_set_password_request(self, NULL);

    /*
     * If the mailbox has not been removed, display an error dialog if
     * the password could not be saved and enable checking.
     */
    if (mn_mailbox_get_active(MN_MAILBOX(self)))
      {
	self_handle_set_password_result(self, result);

	mn_mailbox_enable_checking(MN_MAILBOX(self));
      }

    /* do not call gdk_flush(), we're normally in the main thread */
    GDK_THREADS_LEAVE();
  }}
#line 552 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 200 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_set_set_password_request (MNAuthenticatedMailbox * self, gpointer request)
{
#line 559 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::set_set_password_request"
#line 200 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 200 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 565 "mn-authenticated-mailbox.c"
{
#line 202 "src/mn-authenticated-mailbox.gob"
	
    selfp->set_password_request = request;
    g_object_notify(G_OBJECT(self), "setting-password");
  }}
#line 572 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 207 "src/mn-authenticated-mailbox.gob"
static void 
___9_mn_authenticated_mailbox_check (MNMailbox * mailbox G_GNUC_UNUSED)
#line 578 "mn-authenticated-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->check) \
		(* MN_MAILBOX_CLASS(parent_class)->check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::check"
{
#line 209 "src/mn-authenticated-mailbox.gob"
	
    Self *self = SELF(mailbox);

    if (selfp->checking)
      return;

    PARENT_HANDLER(mailbox);

    selfp->checking = TRUE;
    mn_mailbox_set_error(mailbox, NULL);

    g_object_ref(self);
    mn_thread_create((GThreadFunc) self_check_thread_cb, self);
  }}
#line 600 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 224 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_check_thread_cb (MNAuthenticatedMailbox * self)
{
#line 608 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::check_thread_cb"
#line 224 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 224 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 614 "mn-authenticated-mailbox.c"
{
#line 226 "src/mn-authenticated-mailbox.gob"
	
    self_authenticated_check(self);

    GDK_THREADS_ENTER();

    selfp->checking = FALSE;
    g_object_unref(self);

    gdk_flush();
    GDK_THREADS_LEAVE();
  }}
#line 628 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 238 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_authenticated_check (MNAuthenticatedMailbox * self)
{
#line 635 "mn-authenticated-mailbox.c"
	MNAuthenticatedMailboxClass *klass;
#line 238 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 238 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 641 "mn-authenticated-mailbox.c"
	klass = MN_AUTHENTICATED_MAILBOX_GET_CLASS(self);

	if(klass->authenticated_check)
		(*klass->authenticated_check)(self);
}
#line 238 "src/mn-authenticated-mailbox.gob"
static void 
___real_mn_authenticated_mailbox_authenticated_check (MNAuthenticatedMailbox * self G_GNUC_UNUSED)
{
#line 651 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::authenticated_check"
{
#line 240 "src/mn-authenticated-mailbox.gob"
	
    self->auth_prompted = FALSE;
    self->auth_cancelled = FALSE;
    self->auth_failed = FALSE;

    g_free(selfp->prompted_password_keyring);
    selfp->prompted_password_keyring = NULL;

    selfp->prompted_password_item_id = 0;
  }}
#line 665 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 251 "src/mn-authenticated-mailbox.gob"
void 
mn_authenticated_mailbox_parse_username (MNAuthenticatedMailbox * self, char ** username, char ** domain)
{
#line 672 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::parse_username"
#line 251 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 251 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 678 "mn-authenticated-mailbox.c"
{
#line 253 "src/mn-authenticated-mailbox.gob"
	
    char *at;

    at = strrchr(self->username, '@');
    if (at)
      {
	if (username)
	  *username = g_strndup(self->username, at - self->username);
	if (domain)
	  *domain = g_strdup(at + 1);
      }
    else
      {
	if (username)
	  *username = g_strdup(self->username);
	if (domain)
	  *domain = NULL;
      }
  }}
#line 700 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 278 "src/mn-authenticated-mailbox.gob"
gboolean 
mn_authenticated_mailbox_fill_password (MNAuthenticatedMailbox * self, gboolean may_prompt)
{
#line 707 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::fill_password"
#line 278 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 278 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self), (gboolean )0);
#line 713 "mn-authenticated-mailbox.c"
{
#line 280 "src/mn-authenticated-mailbox.gob"
	
    self->auth_cancelled = FALSE;

    g_free(self->runtime_password);
    self->runtime_password = self_get_password_sync(self);

    /*
     * Check if the user removed the mailbox while we were waiting for
     * the keyring password.
     */
    if (! mn_mailbox_get_active(MN_MAILBOX(self)))
      {
	self->auth_cancelled = TRUE;
	return FALSE;
      }

    if (! self->runtime_password && may_prompt)
      {
	GDK_THREADS_ENTER();

	self->auth_prompted = TRUE;

	if (! self_prompt_for_password(self,
				       &self->runtime_password,
				       self->auth_failed
				       /* translators: the first %s is the mailbox format (eg: IMAP) and the second %s is the mailbox name (eg: john@imapserver.org) */
				       ? _("Mail Notification was unable to log into %s mailbox %s, possibly because the password you have entered is invalid.\n\nPlease re-enter your password.")
				       /* translators: the first %s is the mailbox format (eg: IMAP) and the second %s is the mailbox name (eg: john@imapserver.org) */
				       : _("Enter your password for %s mailbox %s."),
				       MN_MAILBOX(self)->format,
				       MN_MAILBOX(self)->runtime_name))
	  self->auth_cancelled = TRUE;

	gdk_flush();
	GDK_THREADS_LEAVE();
      }

    return ! self->auth_cancelled;
  }}
#line 755 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 320 "src/mn-authenticated-mailbox.gob"
static char * 
mn_authenticated_mailbox_get_password_sync (MNAuthenticatedMailbox * self)
{
#line 762 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::get_password_sync"
#line 320 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 320 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self), (char * )0);
#line 768 "mn-authenticated-mailbox.c"
{
#line 322 "src/mn-authenticated-mailbox.gob"
	
    return mn_keyring_get_password_sync(self->keyring_username,
					self->keyring_domain,
					self->keyring_server,
					self->keyring_protocol,
					self->keyring_authtype,
					self->keyring_port,
					self_get_password_sync_request_cb,
					self);
  }}
#line 781 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 333 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_get_password_sync_request_cb (gpointer request, gpointer data)
{
#line 788 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::get_password_sync_request_cb"
{
#line 335 "src/mn-authenticated-mailbox.gob"
	
    Self *self = data;

    selfp->get_password_request = request;
  }}
#line 797 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 341 "src/mn-authenticated-mailbox.gob"
void 
mn_authenticated_mailbox_auth_failed (MNAuthenticatedMailbox * self)
{
#line 804 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::auth_failed"
#line 341 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 341 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 810 "mn-authenticated-mailbox.c"
{
#line 343 "src/mn-authenticated-mailbox.gob"
	
    /*
     * If the password had been entered at the password prompt, we
     * must remove it from the keyring since the authentication has
     * failed.
     */
    if (self->auth_prompted && selfp->prompted_password_item_id)
      {
	self_delete_password(self,
			     selfp->prompted_password_keyring,
			     selfp->prompted_password_item_id);

	g_free(selfp->prompted_password_keyring);
	selfp->prompted_password_keyring = NULL;

	selfp->prompted_password_item_id = 0;
      }

    self->auth_failed = TRUE;
  }}
#line 833 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 365 "src/mn-authenticated-mailbox.gob"
static gboolean 
mn_authenticated_mailbox_prompt_for_password (MNAuthenticatedMailbox * self, char ** password, const char * format, ...)
{
#line 840 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::prompt_for_password"
#line 365 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 365 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self), (gboolean )0);
#line 365 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (password != NULL, (gboolean )0);
#line 365 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (format != NULL, (gboolean )0);
#line 850 "mn-authenticated-mailbox.c"
{
#line 370 "src/mn-authenticated-mailbox.gob"
	
    char *message;
    gboolean ok;

    g_return_val_if_fail(selfp->auth_dialog == NULL, FALSE);

    MN_STRDUP_VPRINTF(message, format);

    /* keep the title in sync with gnome-authentication-manager */

    /* translators: header capitalization */
    selfp->auth_dialog = gnome_password_dialog_new(_("Authentication Required"),
						   message,
						   self->username,
						   NULL,
						   FALSE);
    g_free(message);

    mn_add_weak_pointer(&selfp->auth_dialog);

    gnome_password_dialog_set_show_userpass_buttons(GNOME_PASSWORD_DIALOG(selfp->auth_dialog), FALSE);
    gnome_password_dialog_set_readonly_username(GNOME_PASSWORD_DIALOG(selfp->auth_dialog), TRUE);
    gnome_password_dialog_set_show_remember(GNOME_PASSWORD_DIALOG(selfp->auth_dialog), TRUE);
    gnome_password_dialog_set_remember(GNOME_PASSWORD_DIALOG(selfp->auth_dialog), GNOME_PASSWORD_DIALOG_REMEMBER_SESSION);

    ok = gnome_password_dialog_run_and_block(GNOME_PASSWORD_DIALOG(selfp->auth_dialog));
    if (ok)
      {
	GnomePasswordDialogRemember remember;

	*password = gnome_password_dialog_get_password(GNOME_PASSWORD_DIALOG(selfp->auth_dialog));

	remember = gnome_password_dialog_get_remember(GNOME_PASSWORD_DIALOG(selfp->auth_dialog));
	if (remember == GNOME_PASSWORD_DIALOG_REMEMBER_SESSION)
	  self_set_prompted_password(self, "session", *password);
	else if (remember == GNOME_PASSWORD_DIALOG_REMEMBER_FOREVER)
	  self_set_prompted_password(self, NULL, *password);
      }

    gtk_widget_destroy(selfp->auth_dialog);

    return ok;
  }}
#line 896 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 414 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_set_prompted_password (MNAuthenticatedMailbox * self, const char * keyring, const char * password)
{
#line 903 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::set_prompted_password"
#line 414 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 414 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 414 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (password != NULL);
#line 911 "mn-authenticated-mailbox.c"
{
#line 418 "src/mn-authenticated-mailbox.gob"
	
    GnomeKeyringResult result;

    /* do not block the main loop */
    gdk_flush();
    GDK_THREADS_LEAVE();

    g_free(selfp->prompted_password_keyring);
    selfp->prompted_password_keyring = g_strdup(keyring);

    result = mn_keyring_set_password_sync(keyring,
					  self->keyring_username,
					  self->keyring_domain,
					  self->keyring_server,
					  self->keyring_protocol,
					  self->keyring_authtype,
					  self->keyring_port,
					  password,
					  &selfp->prompted_password_item_id,
					  self_set_prompted_password_request_cb,
					  self);

    GDK_THREADS_ENTER();

    self_handle_set_password_result(self, result);
  }}
#line 940 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 445 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_set_prompted_password_request_cb (gpointer request, gpointer data)
{
#line 947 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::set_prompted_password_request_cb"
{
#line 447 "src/mn-authenticated-mailbox.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();

    self_set_set_password_request(self, request);

    /* do not call gdk_flush(), we're normally in the main thread */
    GDK_THREADS_LEAVE();
  }}
#line 961 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 458 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_handle_set_password_result (MNAuthenticatedMailbox * self, GnomeKeyringResult result)
{
#line 968 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::handle_set_password_result"
#line 458 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 458 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 974 "mn-authenticated-mailbox.c"
{
#line 460 "src/mn-authenticated-mailbox.gob"
	
    if (result != GNOME_KEYRING_RESULT_OK && result != GNOME_KEYRING_RESULT_CANCELLED)
      mn_show_error_dialog(NULL,
			   _("Unable to save the mailbox password"),
			   /* translators: the first %s is the mailbox format (eg: IMAP) and the second %s is the mailbox name (eg: john@imapserver.org) */
			   _("The password of %s mailbox %s could not be saved to the keyring."),
			   MN_MAILBOX(self)->format,
			   MN_MAILBOX(self)->runtime_name);
  }}
#line 986 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 470 "src/mn-authenticated-mailbox.gob"
gpointer 
mn_authenticated_mailbox_get_password (MNAuthenticatedMailbox * self, GnomeKeyringOperationGetListCallback cb, gpointer data)
{
#line 993 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::get_password"
#line 470 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gpointer )0);
#line 470 "src/mn-authenticated-mailbox.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self), (gpointer )0);
#line 999 "mn-authenticated-mailbox.c"
{
#line 474 "src/mn-authenticated-mailbox.gob"
	
    return gnome_keyring_find_network_password(self->keyring_username,
					       self->keyring_domain,
					       self->keyring_server,
					       NULL,
					       self->keyring_protocol,
					       self->keyring_authtype,
					       self->keyring_port,
					       cb,
					       data,
					       NULL);
  }}
#line 1014 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__

#line 487 "src/mn-authenticated-mailbox.gob"
static void 
mn_authenticated_mailbox_delete_password (MNAuthenticatedMailbox * self, const char * keyring, guint32 item_id)
{
#line 1021 "mn-authenticated-mailbox.c"
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox::delete_password"
#line 487 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 487 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX (self));
#line 487 "src/mn-authenticated-mailbox.gob"
	g_return_if_fail (item_id != 0);
#line 1029 "mn-authenticated-mailbox.c"
{
#line 491 "src/mn-authenticated-mailbox.gob"
	
    char *default_keyring = NULL;

    if (! keyring)
      {
	/*
	 * gnome_keyring_item_delete_sync() does not work if the
	 * passed keyring is NULL, so we must get the default keyring.
	 */
	if (gnome_keyring_get_default_keyring_sync(&default_keyring) != GNOME_KEYRING_RESULT_OK)
	  return;

	keyring = default_keyring;
      }

    gnome_keyring_item_delete_sync(keyring, item_id);

    g_free(default_keyring);
  }}
#line 1051 "mn-authenticated-mailbox.c"
#undef __GOB_FUNCTION__
