/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Qt includes
#include <QString>
#include <QStringList>
#include <QList>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/globals.hpp"
#include "MsXpS/libXpertMassCore/Monomer.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC CleavageMotif
{
  public:
  CleavageMotif(
    PolChemDefCstSPtr pol_chem_def_csp,
    const QString &motif                 = QString(),
    int offset                           = -1,
    Enums::CleavageAction cleavage_action = Enums::CleavageAction::NOT_SET);
  CleavageMotif(const CleavageMotif &other);
  ~CleavageMotif();

  void setPolChemDefCstSPtr(PolChemDefCstSPtr pol_chem_def_csp);
  PolChemDefCstSPtr getPolChemDefCstSPtr() const;

  void setMotif(const QString &motif);
  QString getMotif() const;

  const std::vector<MonomerSPtr> &getMonomersCstRef() const;
  std::vector<MonomerSPtr> &getMonomersRef();

  void setOffset(int offset);
  int getOffset() const;

  void setCleavageAction(Enums::CleavageAction cleavage_action);
  Enums::CleavageAction getCleavageAction() const;

  //////////////// OPERATORS /////////////////////
  CleavageMotif &operator=(const CleavageMotif &other);
  bool operator==(const CleavageMotif &other) const;
  bool operator!=(const CleavageMotif &other) const;

  std::size_t parseSite(const QString &cleavage_site /*"Lys/Pro"*/);
  std::size_t parseMotif(const QString &motif /*"LysPro"*/);

  //////////////// VALIDATIONS /////////////////////
  bool validate(ErrorList *error_list_p) const;
  bool isValid() const;

  protected:
  PolChemDefCstSPtr mcsp_polChemDef = nullptr;
  std::vector<MonomerSPtr> m_monomers;
  std::size_t m_offset;
  Enums::CleavageAction m_cleavageAction = Enums::CleavageAction::NOT_SET;
  mutable bool m_isValid                = false;
};

typedef std::shared_ptr<CleavageMotif> CleavageMotifSPtr;
typedef std::shared_ptr<const CleavageMotif> CleavageMotifCstSPtr;


} // namespace libXpertMassCore
} // namespace MsXpS
