/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef LIBSYSACTIVITY_H_
#define LIBSYSACTIVITY_H_

#include <stdint.h>
#include <stdlib.h>
#include <sys/param.h>
#include <sys/disk.h>
#include <sys/swap.h>
#include <sys/sysctl.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SA_OPEN_CPU
#undef SA_CLOSE_CPU
#undef SA_SMP_CAPABLE
#define SA_CPU_ID
#define SA_CPU_USER
#define SA_CPU_NICE
#define SA_CPU_SYSTEM
#define SA_CPU_IDLE
#undef SA_CPU_WAITING_FOR_IO
#undef SA_CPU_HARDWARE_IRQ
#undef SA_CPU_SOFTWARE_IRQ
#undef SA_CPU_STOLEN
#define SA_CPU_INTR

#define SA_OPEN_DISK
#undef SA_CLOSE_DISK
#define SA_DISK_NAME DS_DISKNAMELEN
#define SA_DISK_READS
#undef SA_DISK_READS_MERGED
#undef SA_DISK_SECTORS_READ
#undef SA_DISK_TIME_SPENT_READING
#define SA_DISK_WRITES
#undef SA_DISK_SECTORS_WRITTEN
#undef SA_DISK_TIME_SPENT_WRITING
#define SA_DISK_BYTES_READ
#define SA_DISK_BYTES_WRITTEN

#define SA_OPEN_MEMORY
#undef SA_CLOSE_MEMORY
#define SA_MEMORY_TOTAL
#define SA_MEMORY_FREE
#define SA_MEMORY_ACTIVE
#define SA_MEMORY_INACTIVE
#undef SA_MEMORY_BUFFERS
#define SA_MEMORY_SWAP_TOTAL
#define SA_MEMORY_SWAP_FREE
#undef SA_MEMORY_SWAP_CACHED
#undef SA_MEMORY_WIRED
#undef SA_MEMORY_CACHED
#undef SA_MEMORY_DIRTY
#undef SA_MEMORY_EXECUTABLE
#undef SA_MEMORY_FILES
#undef SA_MEMORY_LOCKED

#define SA_OPEN_NET
#undef SA_CLOSE_NET
#define SA_NET_INTERFACE_NAME 12 // if_dl.h:67
#define SA_NET_INTERFACE_RECEIVED_BYTES
#define SA_NET_INTERFACE_RECEIVED_PACKETS
#define SA_NET_INTERFACE_RECEIVED_ERRORS
#define SA_NET_INTERFACE_RECEIVED_DROP
#undef SA_NET_INTERFACE_RECEIVED_FIFO
#define SA_NET_INTERFACE_RECEIVED_MULTICAST
#define SA_NET_INTERFACE_SENT_BYTES
#define SA_NET_INTERFACE_SENT_PACKETS
#define SA_NET_INTERFACE_SENT_ERRORS
#undef SA_NET_INTERFACE_SENT_DROP
#undef SA_NET_INTERFACE_SENT_FIFO
#undef SA_NET_INTERFACE_SENT_COMPRESSED
#define SA_NET_INTERFACE_SENT_MULTICAST

#define SA_OPEN_PROCESS
#undef SA_CLOSE_PROCESS
#define SA_PROCESS_PID
#define SA_PROCESS_UID
#define SA_PROCESS_GID
#define SA_PROCESS_FILENAME KI_MAXCOMLEN
#undef SA_PROCESS_CMDLINE
#define SA_PROCESS_PARENT_PID
#define SA_PROCESS_PGRP
#define SA_PROCESS_SID
#define SA_PROCESS_TTY
#define SA_PROCESS_NICE
#define SA_PROCESS_START_TIME

#undef SA_PROCESS_STATE
#define SA_PROCESS_USER_TIME
#define SA_PROCESS_SYS_TIME
#undef SA_PROCESS_THREADS
#define SA_PROCESS_VM_SIZE
#define SA_PROCESS_RSS

#define SA_OPEN_SWAP
#undef SA_CLOSE_SWAP
#define SA_SWAP_NAME MAXPATHLEN
#define SA_SWAP_TOTAL
#define SA_SWAP_FREE
#undef SA_SWAP_TYPE

#include "global.h"

#ifdef __cplusplus
}
#endif

#endif /* LIBSYSACTIVITY_H_ */
