/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#include "tests/support.h"

START_TEST (md5_1)
{
	const char *data = "";
	unsigned char digest[16];
	SmlError *error = NULL;

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, &error);
	sml_fail_unless(!strcmp(md5, "d41d8cd98f00b204e9800998ecf8427e"), "%s", smlErrorPrint(&error));
	smlSafeCFree(&md5);
}
END_TEST

START_TEST (md5_2)
{
	const char *data = "a";
	unsigned char digest[16];
	SmlError *error = NULL;

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, &error);
	sml_fail_unless(!strcmp(md5, "0cc175b9c0f1b6a831c399e269772661"), "%s", smlErrorPrint(&error));
	smlSafeCFree(&md5);
}
END_TEST

START_TEST (md5_3)
{
	const char *data = "abc";
	unsigned char digest[16];
	SmlError *error = NULL;

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, &error);
	sml_fail_unless(!strcmp(md5, "900150983cd24fb0d6963f7d28e17f72"), "%s", smlErrorPrint(&error));
	smlSafeCFree(&md5);
}
END_TEST

START_TEST (md5_4)
{
	const char *data = "message digest";
	unsigned char digest[16];
	SmlError *error = NULL;

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, &error);
	sml_fail_unless(!strcmp(md5, "f96b697d7cb7938d525a2f31aaf161d0"), "%s", smlErrorPrint(&error));
	smlSafeCFree(&md5);
}
END_TEST

START_TEST (md5_5)
{
	const char *data = "abcdefghijklmnopqrstuvwxyz";
	unsigned char digest[16];
	SmlError *error = NULL;

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, &error);
	sml_fail_unless(!strcmp(md5, "c3fcd3d76192e4007dfb496cca67e13b"), "%s", smlErrorPrint(&error));
	smlSafeCFree(&md5);
}
END_TEST

START_TEST (md5_6)
{
	const char *data = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
	unsigned char digest[16];
	SmlError *error = NULL;

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, &error);
	sml_fail_unless(!strcmp(md5, "d174ab98d277d9f5a5611c2c9f419d9f"), "%s", smlErrorPrint(&error));
	smlSafeCFree(&md5);
}
END_TEST

START_TEST (md5_7)
{
	const char *data =  "12345678901234567890123456789012345678901234567890123456789012345678901234567890";
	unsigned char digest[16];
	SmlError *error = NULL;

	smlMD5GetDigest(data, strlen(data), digest);

	char *md5 = smlMD5ToString(digest, &error);
	sml_fail_unless(!strcmp(md5, "57edf4a22be3c955ac49da2e2107b67a"), "%s", smlErrorPrint(&error));
	smlSafeCFree(&md5);
}
END_TEST

@SML_TESTCASE_CODE@

