/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlCommandPrivate SyncML Command Internals
 * @ingroup PrivateLowLevelAPI
 * @brief The private part
 * 
 */
/*@{*/

#ifndef _SML_COMMAND_INTERNALS_H_
#define _SML_COMMAND_INTERNALS_H_

typedef struct SmlCommandAlertPrivate {
	SmlAlertType type;
	SmlAnchor *anchor;
	char *contentType;
	int maxObjSize;
} SmlCommandAlertPrivate;

typedef struct SmlCommandSyncPrivate {
	unsigned int numChanged;
	int maxObjSize;
	SmlBool hasNumChanged;
} SmlCommandSyncPrivate;

typedef struct SmlCommandAccessPrivate {
	char *type;
	SmlItem *item;
} SmlCommandAccessPrivate;

typedef struct SmlCommandChangePrivate {
	GList *items;
	SmlChangeType type;
} SmlCommandChangePrivate;

typedef struct SmlCommandMapPrivate {
	GList *items;
} SmlCommandMapPrivate;

typedef struct SmlCommandResultsPrivate {
	SmlStatus *status;
} SmlCommandResultsPrivate;

typedef union SmlCommandPrivate {
	SmlCommandAlertPrivate alert;
	SmlCommandSyncPrivate sync;
	SmlCommandAccessPrivate access;
	SmlCommandChangePrivate change;
	SmlCommandMapPrivate map;
	SmlCommandResultsPrivate results;
} SmlCommandPrivate;

struct SmlCommand {
	gint refCount;
	SmlCommandType type;
	unsigned int cmdID;
	unsigned int msgID;
	SmlCommandPrivate private;
	SmlLocation *source;
	SmlLocation *target;
	SmlPendingStatus *pendingReply;
	GList *children;
	SmlCommand *parent;
	SmlBool noResp;
	
	unsigned int size;
	
	/** True if the command has already seen a mismatch
	 * in size. If a second mismatch happens, the command is
	 * simply too large */
	SmlBool pushedBack;
};

struct SmlStatus {
	gint refCount;
	unsigned int msgRef;
	unsigned int cmdRef;
	SmlCommandType type;
	char *data;
	SmlAnchor *anchor;
	SmlLocation *sourceRef;
	SmlLocation *targetRef;
	SmlCred *cred;
	SmlChal *chal;
	SmlItem *item;
	
	SmlCommand *result;
};

SmlCommandType smlCommandTypeFromString(const char *name, SmlError **error);
const char *smlCommandTypeToString(SmlCommandType type, SmlError **error);

SmlAlertType smlAlertTypeConvert(unsigned int id, SmlError **error);

#endif //_SML_COMMAND_INTERNALS_H_

/*@}*/

