#include "sw-service-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_service_iface_object_info;

struct _SwServiceIfaceClass {
    GTypeInterface parent_class;
    sw_service_iface_get_static_capabilities_impl get_static_capabilities;
    sw_service_iface_get_dynamic_capabilities_impl get_dynamic_capabilities;
    sw_service_iface_credentials_updated_impl credentials_updated;
};

enum {
    SIGNAL_SERVICE_IFACE_CapabilitiesChanged,
    SIGNAL_SERVICE_IFACE_UserChanged,
    N_SERVICE_IFACE_SIGNALS
};
static guint service_iface_signals[N_SERVICE_IFACE_SIGNALS] = {0};

static void sw_service_iface_base_init (gpointer klass);

GType
sw_service_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwServiceIfaceClass),
        sw_service_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwServiceIface", &info, 0);
    }

  return type;
}

/**
 * sw_service_iface_get_static_capabilities_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetStaticCapabilities on interface com.meego.libsocialweb.Service.
 */
static void
sw_service_iface_get_static_capabilities (SwServiceIface *self,
    DBusGMethodInvocation *context)
{
  sw_service_iface_get_static_capabilities_impl impl = (SW_SERVICE_IFACE_GET_CLASS (self)->get_static_capabilities);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_service_iface_implement_get_static_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetStaticCapabilities D-Bus method
 *
 * Register an implementation for the GetStaticCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_service_iface_implement_get_static_capabilities (SwServiceIfaceClass *klass, sw_service_iface_get_static_capabilities_impl impl)
{
  klass->get_static_capabilities = impl;
}

/**
 * sw_service_iface_get_dynamic_capabilities_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetDynamicCapabilities on interface com.meego.libsocialweb.Service.
 */
static void
sw_service_iface_get_dynamic_capabilities (SwServiceIface *self,
    DBusGMethodInvocation *context)
{
  sw_service_iface_get_dynamic_capabilities_impl impl = (SW_SERVICE_IFACE_GET_CLASS (self)->get_dynamic_capabilities);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_service_iface_implement_get_dynamic_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetDynamicCapabilities D-Bus method
 *
 * Register an implementation for the GetDynamicCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_service_iface_implement_get_dynamic_capabilities (SwServiceIfaceClass *klass, sw_service_iface_get_dynamic_capabilities_impl impl)
{
  klass->get_dynamic_capabilities = impl;
}

/**
 * sw_service_iface_credentials_updated_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * CredentialsUpdated on interface com.meego.libsocialweb.Service.
 */
static void
sw_service_iface_credentials_updated (SwServiceIface *self,
    DBusGMethodInvocation *context)
{
  sw_service_iface_credentials_updated_impl impl = (SW_SERVICE_IFACE_GET_CLASS (self)->credentials_updated);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_service_iface_implement_credentials_updated:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the CredentialsUpdated D-Bus method
 *
 * Register an implementation for the CredentialsUpdated method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_service_iface_implement_credentials_updated (SwServiceIfaceClass *klass, sw_service_iface_credentials_updated_impl impl)
{
  klass->credentials_updated = impl;
}

/**
 * sw_service_iface_emit_capabilities_changed:
 * @instance: The object implementing this interface
 * @arg_caps: const gchar ** (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CapabilitiesChanged signal on interface com.meego.libsocialweb.Service.
 */
void
sw_service_iface_emit_capabilities_changed (gpointer instance,
    const gchar **arg_caps)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_SERVICE_IFACE));
  g_signal_emit (instance,
      service_iface_signals[SIGNAL_SERVICE_IFACE_CapabilitiesChanged],
      0,
      arg_caps);
}

/**
 * sw_service_iface_emit_user_changed:
 * @instance: The object implementing this interface
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * UserChanged signal on interface com.meego.libsocialweb.Service.
 */
void
sw_service_iface_emit_user_changed (gpointer instance)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_SERVICE_IFACE));
  g_signal_emit (instance,
      service_iface_signals[SIGNAL_SERVICE_IFACE_UserChanged],
      0);
}

static inline void
sw_service_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_service_iface_get_type (),
      &_sw_service_iface_object_info);

  /**
   * SwServiceIface::capabilities-changed:
   * @arg_caps: const gchar ** (FIXME, generate documentation)
   *
   * The CapabilitiesChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  service_iface_signals[SIGNAL_SERVICE_IFACE_CapabilitiesChanged] =
  g_signal_new ("capabilities-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      G_TYPE_STRV);

  /**
   * SwServiceIface::user-changed:
   *
   * The UserChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  service_iface_signals[SIGNAL_SERVICE_IFACE_UserChanged] =
  g_signal_new ("user-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__VOID,
      G_TYPE_NONE,
      0);

}
static void
sw_service_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_service_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_service_iface_methods[] = {
  { (GCallback) sw_service_iface_get_static_capabilities, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) sw_service_iface_get_dynamic_capabilities, g_cclosure_marshal_VOID__POINTER, 70 },
  { (GCallback) sw_service_iface_credentials_updated, g_cclosure_marshal_VOID__POINTER, 141 },
};

static const DBusGObjectInfo _sw_service_iface_object_info = {
  0,
  _sw_service_iface_methods,
  3,
"com.meego.libsocialweb.Service\0GetStaticCapabilities\0A\0caps\0O\0F\0N\0as\0\0com.meego.libsocialweb.Service\0GetDynamicCapabilities\0A\0caps\0O\0F\0N\0as\0\0com.meego.libsocialweb.Service\0CredentialsUpdated\0A\0\0\0",
"com.meego.libsocialweb.Service\0CapabilitiesChanged\0com.meego.libsocialweb.Service\0UserChanged\0\0",
"\0\0",
};


