#include "sw-contacts-query-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_contacts_query_iface_object_info;

struct _SwContactsQueryIfaceClass {
    GTypeInterface parent_class;
    sw_contacts_query_iface_open_view_impl open_view;
};

static void sw_contacts_query_iface_base_init (gpointer klass);

GType
sw_contacts_query_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwContactsQueryIfaceClass),
        sw_contacts_query_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwContactsQueryIface", &info, 0);
    }

  return type;
}

/**
 * sw_contacts_query_iface_open_view_impl:
 * @self: The object implementing this interface
 * @in_query: const gchar * (FIXME, generate documentation)
 * @in_params: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * OpenView on interface com.meego.libsocialweb.ContactsQuery.
 */
static void
sw_contacts_query_iface_open_view (SwContactsQueryIface *self,
    const gchar *in_query,
    GHashTable *in_params,
    DBusGMethodInvocation *context)
{
  sw_contacts_query_iface_open_view_impl impl = (SW_CONTACTS_QUERY_IFACE_GET_CLASS (self)->open_view);

  if (impl != NULL)
    {
      (impl) (self,
        in_query,
        in_params,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_contacts_query_iface_implement_open_view:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the OpenView D-Bus method
 *
 * Register an implementation for the OpenView method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_contacts_query_iface_implement_open_view (SwContactsQueryIfaceClass *klass, sw_contacts_query_iface_open_view_impl impl)
{
  klass->open_view = impl;
}

static inline void
sw_contacts_query_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_contacts_query_iface_get_type (),
      &_sw_contacts_query_iface_object_info);

}
static void
sw_contacts_query_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_contacts_query_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_contacts_query_iface_methods[] = {
  { (GCallback) sw_contacts_query_iface_open_view, sw_marshal_VOID__STRING_BOXED_POINTER, 0 },
};

static const DBusGObjectInfo _sw_contacts_query_iface_object_info = {
  0,
  _sw_contacts_query_iface_methods,
  1,
"com.meego.libsocialweb.ContactsQuery\0OpenView\0A\0query\0I\0s\0params\0I\0a{ss}\0view\0O\0F\0N\0o\0\0\0",
"\0\0",
"\0\0",
};


