#include "osl/move_generator/openKingRoad.h"
#include "osl/move_action/store.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/move.h"
#include "osl/container/moveVector.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::move_action;
using namespace osl::move_generator;

class OpenKingRoadTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(OpenKingRoadTest);
  CPPUNIT_TEST(testSimple0);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSimple0();
};


void OpenKingRoadTest::
testSimple0()
{
  NumEffectState state(CsaString(
    "P1 *  *  *  *  *  *  * -OU * \n"
    "P2 *  *  *  *  *  *  * -KI * \n"
    "P3 *  *  *  *  *  * +KI *  * \n"
    "P4 *  *  *  *  *  *  *  *  * \n"
    "P5 *  *  *  *  *  *  *  *  * \n"
    "P6 *  *  *  *  *  *  *  *  * \n"
    "P7 *  * -KE *  *  *  *  *  * \n"
    "P8 * +FU+OU *  *  *  *  *  * \n"
    "P9 *  *  * +KY *  *  *  *  * \n"
    "P+00KI\n"
    "P-00AL\n"
    "-\n").getInitialState());
  {
    MoveVector moves;
    {
      Store store(moves);
      OpenKingRoad<BLACK>::generate(state, store);
    }
    // shouldPromoteなので 「72香不成」は生成しない
    CPPUNIT_ASSERT_EQUAL((size_t)10u, moves.size());
  }

  {
    MoveVector moves;
    {
      Store store(moves);
      OpenKingRoad<WHITE>::generate(state, store);
    }
    CPPUNIT_ASSERT_EQUAL((size_t)5u, moves.size());
  }
  
}

CPPUNIT_TEST_SUITE_REGISTRATION(OpenKingRoadTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
