#include "osl/effect_util/unblockableCheck.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::effect_util;

class UnblockableCheckTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(UnblockableCheckTest);
  CPPUNIT_TEST(testSamples);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSamples();
};

CPPUNIT_TEST_SUITE_REGISTRATION(UnblockableCheckTest);

void UnblockableCheckTest::testSamples()
{
  {
    const NumEffectState state(CsaString(
				 "P1 *  *  *  *  *  *  * -OU * \n"
				 "P2 *  *  *  *  *  *  * +KI * \n"
				 "P3 *  *  *  *  *  *  * +FU * \n"
				 "P4 *  *  *  *  *  *  *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7 *  *  *  *  *  *  *  *  * \n"
				 "P8 *  *  *  *  *  *  *  *  * \n"
				 "P9 *  * +OU *  *  *  *  *  * \n"
				 "P+00KI\n"
				 "P-00AL\n"
				 "-\n").getInitialState());
    CPPUNIT_ASSERT(UnblockableCheck::isMember(WHITE,state));
    CPPUNIT_ASSERT(! UnblockableCheck::isMember(BLACK,state));
  }
  {
    const NumEffectState state(CsaString(
				 "P1 *  *  *  *  * +HI * -OU * \n"
				 "P2 *  *  *  *  *  *  * +GI * \n"
				 "P3 *  *  *  *  *  *  * +FU * \n"
				 "P4 *  *  *  *  *  *  *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  * -KY *  *  *  *  *  * \n"
				 "P7 *  *  *  *  *  *  *  *  * \n"
				 "P8 *  *  *  *  *  *  *  *  * \n"
				 "P9 *  * +OU *  *  *  *  *  * \n"
				 "P+00KI\n"
				 "P-00AL\n"
				 "-\n").getInitialState());
    CPPUNIT_ASSERT(UnblockableCheck::isMember(WHITE,state));
    CPPUNIT_ASSERT(! UnblockableCheck::isMember(BLACK,state));
  }
  {
    const NumEffectState state(CsaString(
				 "P1 *  *  *  *  * +HI * -OU * \n"
				 "P2 *  *  *  *  *  *  * +KA * \n"
				 "P3 *  *  *  *  *  *  * +FU * \n"
				 "P4 *  *  *  *  *  *  *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  * -KY *  *  *  *  *  * \n"
				 "P7 *  *  *  *  *  *  *  *  * \n"
				 "P8 *  *  * -NG *  *  *  *  * \n"
				 "P9 *  * +OU *  *  *  *  *  * \n"
				 "P+00KI\n"
				 "P-00AL\n"
				 "-\n").getInitialState());
    CPPUNIT_ASSERT(! UnblockableCheck::isMember(WHITE,state));
    CPPUNIT_ASSERT(UnblockableCheck::isMember(BLACK,state));
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
