/* hash.h
 */
#ifndef STL_HASH_H
#define STL_HASH_H
#if (__GNUC__ >= 4 && __GNUC_MINOR__ >=3)
#  include <tr1/functional>
#else
#  include <boost/functional/hash_fwd.hpp>
#endif

namespace osl
{
  namespace stl
  {
    template <class T>
    struct hash;

#if (__GNUC__ >= 4 && __GNUC_MINOR__ >=3)
    template <class T>
    struct hash : public std::tr1::hash<T>
    {
    };
#else
    template <class T>
    struct hash : public boost::hash<T>
    {
    };
#endif
  } // namespace stl
} // namespace stl

#endif /* STL_HASH_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
