/* noAddEffectFilter.h
 */
#ifndef _NOADDEFFECTFILTER_H
#define _NOADDEFFECTFILTER_H

#include "osl/state/numEffectState.h"
#include "osl/move_action/concept.h"
namespace osl
{
  namespace move_action
  {
    /**
     * posに利きをつける手をフィルタ
     */
    template<class OrigAction>
    class NoAddEffectFilter
    {
      BOOST_CLASS_REQUIRE(OrigAction,osl::move_action,Concept);
      const NumEffectState& state;
      OrigAction & action;
      Square target;
    public:
      NoAddEffectFilter(const NumEffectState& s, OrigAction & action,Square target) : state(s), action(action),target(target) {}
      void simpleMove(Square from,Square to,Ptype ptype, bool isPromote,Player p,Move m){
	if(!state.hasEffectIf(newPtypeO(p,ptype),to,target))
	  action.simpleMove(from,to,ptype,isPromote,p,m);
      }
      void unknownMove(Square from,Square to,Piece p1,Ptype ptype,bool isPromote,Player p,Move m){
	if(!state.hasEffectIf(newPtypeO(p,ptype),to,target))
	  action.unknownMove(from,to,p1,ptype,isPromote,p,m);
      }
      void dropMove(Square to,Ptype ptype,Player p,Move m){
	if(!state.hasEffectIf(newPtypeO(p,ptype),to,target))
	  action.dropMove(to,ptype,p,m);
      }
      // old interfaces
      void simpleMove(Square from,Square to,Ptype ptype, 
		      bool isPromote,Player p)
      {
	simpleMove(from,to,ptype,isPromote,p,
		   Move(from,to,ptype,PTYPE_EMPTY,isPromote,p));
      }
      void unknownMove(Square from,Square to,Piece captured,
		       Ptype ptype,bool isPromote,Player p)
      {
	unknownMove(from,to,captured,ptype,isPromote,p,
		    Move(from,to,ptype,captured.ptype(),isPromote,p));
      }
      void dropMove(Square to,Ptype ptype,Player p)
      {
	dropMove(to,ptype,p,
		 Move(to,ptype,p));
      }
    };
  } // namespace move_action
} // namespace osl


#endif /* _NOADDEFFECTFILTER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
