/* reorder.h
 */
#ifndef OSL_MISC_REORDER_H
#define OSL_MISC_REORDER_H
#include <algorithm>

namespace osl
{
  namespace misc
  {
    struct Reorder
    {
      /** first から last を indices に書かれて順番で並べ変える */
      template <class RandomIterator, class OrderArray>
      static void reorder(RandomIterator first, RandomIterator last,
			  const OrderArray& indices)
      {
	const int size = last - first;
	for (int i=0; i<size-1; ++i)	// we do not need to swap the last one
	{
	  int swap_target = indices[i];
	  while (swap_target < i)
	    swap_target = indices[swap_target];
	  std::swap(*(first+i), *(first+swap_target));
	}
      }
    };
  }
}

#endif /* OSL_MISC_REORDER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
