#ifndef _NOT_BY_ACTION_H
#define _NOT_BY_ACTION_H
#include "osl/piece.h"
#include "osl/square.h"
namespace osl
{
  /**
   * exceptPiece以外の場合にactionを呼び出す
   *
   * 自分自身が動いて合い駒するのを防ぐ
   */
  template<class Action>
  class PieceFilter
  {
  private:
    Action & ac;
    Piece piece;
  public:
    PieceFilter(Action & a,Piece p) :ac(a),piece(p){
    }
    template<Player P,Ptype Type>
    void doActionPtype(Piece p1,Square to){
      if(p1!=piece){
	ac.template doActionPtype<P,Type>(p1,to);
      }
    }
    template<Player P>
    void doAction(Piece p1,Square to){
      if(p1!=piece){
	ac.template doAction<P>(p1,to);
      }
    }
    bool done() const{ return ac.done(); } 
  };

}
#endif // _NOT_BY_ACTION_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
