/*
    libodsstream is a library to read and write ODS documents as streams
    Copyright (C) 2013  Olivier Langella <Olivier.Langella@moulon.inra.fr>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "odsdocreader.h"
#include "odsexception.h"
#include <QDebug>
#include "./saxreader/saxhandlercontentxml.h"
#include <quazip/quazipfile.h>

OdsDocReader::OdsDocReader(OdsDocHandlerInterface & handler): _handler(handler)
{
}

OdsDocReader::~OdsDocReader()
{
    if (_p_quaZip!= 0) {
        if (_p_quaZip->isOpen()) {
            _p_quaZip->close();
            delete _p_quaZip;
            _p_quaZip = 0;
        }
    }
}



void OdsDocReader::parse(QFile & odsFile) {
    odsFile.open(QIODevice::ReadOnly);
    parse(&odsFile);
    odsFile.close();
}

void OdsDocReader::parse(QIODevice * p_inputstream) {
    _p_quaZip = new QuaZip(p_inputstream);
    _p_quaZip->open(QuaZip::mdUnzip);

    qDebug() << "OdsDocReader::OdsDocReader(QIODevice * device) begin";
    for(bool more=_p_quaZip->goToFirstFile(); more; more=_p_quaZip->goToNextFile()) {
        qDebug() << _p_quaZip->getCurrentFileName();

        if (_p_quaZip->getCurrentFileName() == "content.xml") {

            SaxHandlerContentXml parser(*this);

            QXmlSimpleReader reader;
            reader.setContentHandler(&parser);
            reader.setErrorHandler(&parser);

            qDebug() << "Parsing XML input file '" << _p_quaZip->getCurrentFileName()
                     << "'" << endl;

            QuaZipFile zip_file(_p_quaZip);

            QXmlInputSource xmlInputSource(&zip_file);

            if (reader.parse(xmlInputSource))
            {
            }
            else
            {
                qDebug() << "error "
                         << parser.errorString();
                throw OdsException(QObject::tr("error reading masschroqML input file :\n").append(parser.errorString()));
            }
            qDebug() << "contentXml : DONE on file '"
                     << _p_quaZip->getCurrentFileName()
                     << "'" << endl;
        }
    }
    if (_p_quaZip!= 0) {
        if (_p_quaZip->isOpen()) {
            _p_quaZip->close();
            delete _p_quaZip;
            _p_quaZip = 0;
        }
    }
    this->endDocument();

}

void OdsDocReader::startInsideLine() {
    _column_number= 0;
    startLine();
}

void OdsDocReader::setInsideCell(const OdsCell & cell) {
    _column_number++;
    qDebug() << "OdsDocReader::setCell " << cell.getOfficeValueType()<< " "  << cell.toString();
    if (cell.isDate()) {
        qDebug() << "OdsDocReader::setCell date " << cell.getDateTimeValue().toString(Qt::ISODate) << "  " << cell.getDateTimeValue().date().day()<< "  " << cell.getDateTimeValue().date().month();
    }
    else if (cell.isString()) {
        qDebug() << "OdsDocReader::setCell string " << cell.getStringValue();
    }
    else if (cell.isDouble()) {
        qDebug() << "OdsDocReader::setCell double " << cell.getDoubleValue();
    }
    setCell(cell);
}
