with GNATCOLL.Projects; use GNATCOLL.Projects;
with GNATCOLL.Traces;   use GNATCOLL.Traces;
with GNATCOLL.VFS;      use GNATCOLL.VFS;
with GNAT.Directory_Operations; use GNAT.Directory_Operations;
with GNAT.IO;           use GNAT.IO; --  not text_io to avoid CR+LF

procedure Objects is
   use Library_Info_Lists;
   Env  : Project_Environment_Access;
   Tree : Project_Tree;
   LIs  : Library_Info_List;
   C    : Library_Info_Lists.Cursor;
   Current_Dir : constant Virtual_File := Get_Current_Dir;
begin
   Parse_Config_File;

   Initialize (Env);
   Env.Set_Xrefs_Subdir ("SCIL");
   Env.Set_Object_Subdir ("codepeer");
   Tree.Load (Create ("sample.gpr"), Env);

   LIs.Clear;
   Tree.Root_Project.Library_Files
      (Recursive          => True,
       List               => LIs,
       Xrefs_Dirs         => True);
   C := First (LIs);
   while Has_Element (C) loop
      Put_Line ("recursive LI="
         & Format_Pathname
            (+Relative_Path (Element (C).Library_File, Current_Dir),
             UNIX));
      Next (C);
   end loop;

   LIs.Clear;
   Tree.Root_Project.Library_Files
      (Recursive          => False,
       List               => LIs,
       Xrefs_Dirs         => True);
   C := First (LIs);
   while Has_Element (C) loop
      Put_Line ("non-recursive LI="
         & Format_Pathname
            (+Relative_Path (Element (C).Library_File, Current_Dir),
             UNIX));
      Next (C);
   end loop;
end Objects;
